function sigsynt = AddWPDSegSynt(matrupt,sigseg,D)

%
% function SigSynt = AddWPDSegSynt(MatRup,SigSegSynt,D)
% Reconstruct signal from its segmentation matrix
% obtained with MakeSegWPD.
% The overlapping is taken into acount.
%
% Output sigsynt is the corresponding synthesized signal
% (column vector)
%
% signal = ones(1,8192);
% indrupt = 0:512:8192; 
% D=7;
% [ MatRupt, SigSeg ] = MakeSegWPD(signal,indrupt,D);
% SigSynt = AddWPDSegSynt(MatRupt,SigSeg,D);
% plot(signal), hold on, plot(SigSynt,'r'), hold off;

recouv = 2^D/2;
l_sig = matrupt(end,2);

sigsynt = zeros(l_sig,1);

nframes = size(matrupt,1);

for k = 1:nframes
     sigsynt(matrupt(k,1):matrupt(k,2)) = ...
          sigsynt(matrupt(k,1):matrupt(k,2)) + sigseg{k};
end

% Removes the padded borders
sigsynt  = sigsynt(recouv+1:end-recouv);
