function [sigsynt,sigcomp] = ChooseCoder(signal,lfen,pas,Fc,seg,tra,alo,qua,Fs,D,qmf,axe1Hndl);

% [sigsynt,sigcomp] = ChooseCoder(signal,lfen,pas,Fc,seg,tra,alo,qua,Fs,D,qmf,axe1Hndl)
%
% Fonction utilise pour la dmo CodDemo, permet de choisir 
% entre les diffrentes fonctions de Codage
%


% On va faire des switch case
strtest = num2str([ seg tra alo qua ]);

% Pointeur de souris, pour indiquer les tapes
sablier0 = [ NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN ...
  NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 1 NaN ...
NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN 1 1 1 1 1 1 NaN NaN NaN ...
NaN NaN NaN 1 1 1 1 1 1 2 2 1 1 1 NaN NaN NaN NaN 1 2 2 2 1 1 1 2 2 2 1 1 1 ...
NaN NaN 1 2 2 2 1 1 1 1 2 2 2 1 1 1 1 1 2 2 2 1 1 1 1 1 2 2 2 1 1 1 2 2 2 2 ...
1 1 1 1 1 1 2 2 2 1 1 1 2 2 2 2 1 1 1 1 1 1 2 2 2 1 1 1 1 1 2 2 2 1 1 1 1 1 ...
2 2 2 1 1 1 NaN NaN 1 2 2 2 1 1 1 1 2 2 1 1 1 NaN NaN NaN NaN 1 2 2 2 1 1 ...
1 1 1 1 1 NaN NaN NaN NaN NaN NaN 1 1 1 1 1 1 NaN NaN NaN NaN NaN NaN NaN ...
NaN NaN NaN NaN NaN NaN NaN 1 NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN ...
NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN NaN ...
NaN NaN NaN ];
sablier0 = reshape(sablier0,16,16);
sablier1 = fliplr(sablier0');
sablier2 = flipud(sablier0);
sablier3 = sablier0';
indptr = 0;
eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
indptr = rem(indptr+1,4);

% Principal probleme : Codage diffrent pour (DCT ou MLT) par rapport 
%                      aux ondelettes
% Il n'est pas possible d'avoir une meme structure de traitement
% (un peu oriente objet) pour tous les cas, ... 
% si on veux traiter au mieux chaque cas (rapidement).

% Choix : D'abord la transforme, ensuite le traitement dans les 2 cas
%         (Ondelettes ou DCT/MLT)

% --------------------------------------------------------------------
%                 PREMIRE PARTIE : CODAGE PAR ONDELETTES
% --------------------------------------------------------------------

N = length(signal);

% ------------------------

switch tra                                   % ------------------------
   case 3                                    %     Ondelettes
   
                                              % ------------------------
     switch seg                               %  1. Segmentation
       case 1                                 %        - Fixe 
         vectind = 0:lfen:N;
         vectind(end) = N; 
%         sigcomp.seg = lfen;
         eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
         indptr = rem(indptr+1,4);

                                              % ------------------------
       case 2                                 %  2. Segmentation 
                                              %        - Adapte
         % Calcul du CEL
         [ CEL, vectind,indpos ] = fastCEL2(signal,lfen,min(pas,floor(lfen/4)),0,0);
         ind = find( (CEL(2:end-1)>CEL(3:end)) & ...
                     (CEL(2:end-1)>CEL(1:end-2)) & ...
                      CEL(2:end-1)> -0.25 );        
                      % On garde les maximas locaux positifs
         % Vecteur contenant les indices des ruptures
         vectind = [ 0 vectind(ind+1) N ] ;
         tmin = 2^D;
         vectind(1+find(diff(vectind,1)<tmin) ) = [];
         
         % Pronfondeur maximale de dcomposition pour les tranches.
         eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
         indptr = rem(indptr+1,4);
         
         
     end %seg

     sigcomp.seg = vectind;
     d_ind = log2(diff(vectind,1));             % ------------------------------
                                                % traitement de chaque tranche
                                                % ------------------------------
     
     eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
     indptr = rem(indptr+1,4);

    [ MatRupt, SigSeg ] = MakeSegWPD(signal,vectind,D);
    nframes = size(SigSeg,2);
    sigsegsynt = cell(1,nframes);
    
    Debit = floor((Fs*16)/Fc);
    
     sigsegsynt = [];
     for k = 1:nframes
          tranche = SigSeg{k};
          N_tr = length(tranche);                    

                                                  % ------------------------
          wp = WPAnalysis(tranche,D,qmf);         % Analyse par Ondelettes
          stree = CalcStatTree(wp,'Entropy');      %        - Best Basis

          [sigcomp(k).btree,vtree] = BestBasis(stree,D);
          sigcomp(k).coef = Extractwp(wp,tree2node(sigcomp(k).btree));
          
                                                    % ------------------------
                                                    % Allocation 
                                                    % ------------------------
         
          switch alo
                                                           % ------------------------
            case 1                                         %    1. nergtique
                                                           % ------------------------
          
          
             [val,ind] = sort(abs(sigcomp(k).coef));
                                                           % ------------------------
             nbkept = floor( (N_tr)/Fc );            % Conservation des coeffs.
             sigcomp(k).coef(ind(1:end-nbkept)) = 0;
        
                                                          % ----------------------------
            case 2                                        %      2. Psychoacoustique
                                                          % ----------------------------
               % Courbe de masquage
                 if Fs <= 16000
                    [CM , SMR] = masq8_16k(tranche,Fs);
                 else
                    [CM , SMR] = maxmasq(tranche,Fs);
                 end
       
               % Allocation
                 sigcomp(k).bpss = allocSMRBB(wp,SMR,sigcomp(k).btree,Debit,Fs);
               % Quantification des paquets
                 wpquant = Q_unifWP(sigcomp(k).coef,sigcomp(k).bpss,sigcomp(k).btree);
              % paquets gards
                 sigcomp(k).coef = wpquant;

                                                          % ----------------------------
            case 3                                        %      3. Melange Psycho-NRJ
                                                          % ----------------------------
               % Courbe de masquage
                 if Fs <= 16000
                    [CM , SMR] = masq8_16k(tranche,Fs);
                 else
                    [CM , SMR] = maxmasq(tranche,Fs);
                 end
       
               % Allocation
                 sigcomp(k).bpss = allocSMRNRJBB(wp,SMR,sigcomp(k).btree,Debit,Fs);
               % Quantification des paquets
                 wpquant = Q_unifWP(sigcomp(k).coef,sigcomp(k).bpss,sigcomp(k).btree);
              % paquets gards
                 sigcomp(k).coef = wpquant;

         end %alo

                                                    % ------------------------
                                                    %         Synthse
          wpsynt = Fillwp(sigcomp(k).coef,tree2node(sigcomp(k).btree),N_tr);
          sigsynt = WPSynthesis(sigcomp(k).btree,wpsynt,qmf);
          
          sigsegsynt{k} = sigsynt(1:N_tr)';
          
          % Sablier tournant
          eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
          indptr = rem(indptr+1,4);
          % Indication de l'avancement sur l'axe
          axes(axe1Hndl)
          set(gca,'Xtick',vectind(1:k+1)/Fs), grid on
          drawnow
     end
 
     sigsynt = AddWPDSegSynt(MatRupt,sigsegsynt,D);
     eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
     indptr = rem(indptr+1,4);

% --------------------------------------------------------------------
%                 DEUXIME PARTIE : CODAGE PAR DCT ou MLT
% --------------------------------------------------------------------

                                            % ------------------------
otherwise                                   %  (tra =) 1.DCT ou 2.MLT


                                            % ------------------------
   switch seg                               %  1. Segmentation
      case 1                                %       - Fixe 

                                                  % ------------------------
         switch tra                               %  2. Transformation
             case 1                               %        - 1.DCT
               matsig = DCT_analysis(signal,lfen);
               l_tr = 0;
               eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
               indptr = rem(indptr+1,4);
             case 2                               %        - 2.MLT
               matsig = MLT_analysis(signal,lfen);
               l_tr = lfen;
               eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
               indptr = rem(indptr+1,4);
         end %sw tra2
         sigcomp.seg = lfen;
         
         eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
         indptr = rem(indptr+1,4);
 
                                                  % ------------------------
         switch alo                               %  3. Allocation
             case 1                               %        - NRJ
               % Pour chaque longueur diffrents facteur de compression
               % on fixe la "taille des sous bandes" : coefbpss
               coefbpss = 4;
               [sigcomp.alloc,sigcomp.coef] = allocMLT(matsig,coefbpss,Fc);
	       matsigsynt = unallocMLT(sigcomp.alloc,sigcomp.coef,lfen);
 
               eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
               indptr = rem(indptr+1,4);
               
             case 2                               %        - RSM 
               % Calcul du RSM
               [ cm,SMR ] = maxmasqmat(signal,lfen,0,Fs);
               
               % Discretisation du SMR suivant les sous bandes
               nb_ssband = 32;
               mat_smr = discretSMR(SMR,nb_ssband);
 
               eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
               indptr = rem(indptr+1,4);
              
               % Nrj des diffrentes sous bandes pour bit max dans chaque ssbande
               max_ssband = MAX_matssband(matsig,nb_ssband);
               
               % Allocation
               sigcomp.alloc = allocmatRSM(mat_smr,Fc,max_ssband,lfen);
               
               % Quantification
               sigcomp.coef = Q_unifmat(matsig',sigcomp.alloc);
               
               % pour la synthse
               matsigsynt = sigcomp.coef';
 
               eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
               indptr = rem(indptr+1,4);
               
           
         end %alo

         eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
         indptr = rem(indptr+1,4);


                                                  % ------------------------
         switch tra                               %  3. Synthse
             case 1                               %        - DCT
               sigsynt = DCT_synthesis(matsigsynt);
             case 2                               %        - MLT
               sigsynt = MLT_synthesis(matsigsynt);
         end %tra2

         eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
         indptr = rem(indptr+1,4);

                                            % ------------------------
                                            %  1. Segmentation
      case 2                                %       - Adapte
        % Calcul du CEL
           [ CEL, vectind,indpos ] = fastCEL2(signal,lfen,min(floor(lfen/4),pas),0,0);
         ind = find( (CEL(2:end-1)>CEL(3:end)) & ...
                     (CEL(2:end-1)>CEL(1:end-2)) & ...
                      CEL(2:end-1)> -0.25 );        
                      % On garde les maximas locaux positifs
         % Vecteur contenant les indices des ruptures
         vectind = [ 0 vectind(ind+1) N ] ;
         tmin = lfen/4; % taille minimale des tranches analyses
         vectind(1+find(diff(vectind,1)<tmin) ) = [];
         sigcomp.seg = vectind;

         sigsynt = zeros(N,1);

         eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
         indptr = rem(indptr+1,4);


                                                  % ------------------------
         switch tra                               %  2. Transformation
             case 1                               %        - DCT
               for k = 1:length(vectind)-1
                    tranche = signal(vectind(k)+1:vectind(k+1));
                    sigcomp(k).coef = dct(tranche);
                                                  % ------------------------
                                                  % Allocation
               coefbpss = 4;
               [sigcomp(k).alloc,sigcomp(k).coef] = allocMLT(sigcomp(k).coef,coefbpss,Fc);
               dctcomp = unallocMLT(sigcomp(k).alloc,sigcomp(k).coef,length(tranche));
	       sigsynt(vectind(k)+1:vectind(k+1)) = idct(dctcomp);
	                        
                    
                  % Indication de l'avancement sur l'axe
                   axes(axe1Hndl)
                    set(gca,'Xtick',vectind(1:k+1)/Fs), grid on
                    drawnow

     
                    eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
                    indptr = rem(indptr+1,4);
               end

             case 2                               %        - MLT
               for k = 1:length(vectind)-1
                    tranche = signal(vectind(k)+1:vectind(k+1));
                   % Indication de l'avancement sur l'axe
                   axes(axe1Hndl)
                    set(gca,'Xtick',vectind(1:k+1)/Fs), grid on
                    drawnow

                   eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
                    indptr = rem(indptr+1,4);                   
               end
             
         end %tra3
   end %seg
end %tra1

eval([ 'set(gcf,''pointer'',''custom'',''pointershapecdata'',sablier' num2str(indptr) ')' ]);
indptr = rem(indptr+1,4);