function CodDemo(action)

%  Demonstration des differentes chaines de codage
% fonctionne avec des fichiers wave
%

% Possible action
%   encode       : encode with block arrangment
%   openfile     : choose and plot wave file to encode
%   play         : play the choosen file
%   play synt    : play the synthesized file
%   save         : save the synthesized file
%
%
%   info
%   close

persistent signal sigsynt sigcomp Fs HndlList qmf savecount fname;

if nargin<1,
   action='initialize';
   % Signal de depart : diapason
   Fs = 8000;
   N = 8192;
   t = (0:N-1)/Fs;
   signal = sin(440*t*2*pi);
   sigsynt = signal.^2 - mean(signal.^2);
   qmf = MakeONFilter('Haar');
   savecount = 1;
end             
  
 %===================================
 % General informations
 
 bgcolor = [.5 .5 .5];
 fgcolor = [.8 .8 .8];
   if strcmp(action,'initialize'),
       figNumber=figure( ...
        'Name','Coding Toolbox Demonstration', ...
        'NumberTitle','off', ...
        'Backingstore','off', ...
        'Visible','on');
    ax1Hndl=axes( ...
        'Units','normalized', ...
        'Position',[ .05 .1 .6 .3], ...
        'Drawmode','fast', ... 
        'Visible','on');
     
    %===================================
    % Information for all buttons
    menutop=0.95;
    top=0.9;
    left=0.75;
    bottom=0.05;
    xLabelPos=0.75;
    labelWid=0.15;
    labelHt=0.03;
    btnWid=0.20;
    btnHt=0.06;
    textHeight = 0.05;
    textWidth = 0.07;
    % Spacing between the button and the next command's label
    spacing=0.02;
    btnOffset=0;
    % for Box frames
    frmHt = .2;
    frmWd = .2;
    frmHspace = .03;
    frmVspace = .05;

    pupHt = frmHt/3;
    pupVoff = frmHt/3;
    pupHoff = .02;
    pupWd = frmHt - 2*pupHoff;
    
    %====================================
    % The CONSOLE frame
    % Use the frame's userdata to hold the tones matrix
    frmBorder=0.02;
    yPos=bottom-frmBorder;
    frmBorder=0.019; frmBottom=0.04; 
    frmHeight = 0.92; frmWidth = btnWid;
    yPos=frmBottom-frmBorder;
    frmPos=[left-frmBorder yPos frmWidth+2*frmBorder frmHeight+2*frmBorder];
    h=uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
	'BackgroundColor',[0.5 0.5 0.5]);
       
    %====================================
    % Coding Frame Boxes
    
        %====================================
        % Joining lines
        uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',[frmHspace/2 1-frmHt/2-frmVspace 3*(frmWd+frmHspace) 0.01 ], ...
        'BackgroundColor',fgcolor);
    
        uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',[frmHspace/2+frmWd 1-1.5*frmHt-2*frmVspace 2*(frmWd+1.5*frmHspace) 0.01 ], ...
        'BackgroundColor',fgcolor);
    
        uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',[frmHspace/2+3*(frmWd+frmHspace) 1-1.5*frmHt-2*frmVspace 0.01 frmHt+frmVspace+0.01], ...
        'BackgroundColor',fgcolor);
    
        %====================================
        % Segmentation Bloc
    frmNb = 0;
    leftfrm = frmHspace+(frmWd+frmHspace)*frmNb;
    butfrm = 1-(frmVspace+frmWd);
    frmPos = [   leftfrm butfrm frmWd frmHt ];
    frmbox1 = uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
        'BackgroundColor',fgcolor);
    
    frmstr = 'Time Seg';
    txtPos = [leftfrm+pupHoff butfrm+pupVoff+pupHt-.02 pupWd pupHt ];
    frmtxt = uicontrol(...
        'Style','text', ...
        'Units','normalized', ...
        'Position',txtPos, ...
        'String',frmstr, ...
        'BackgroundColor',fgcolor);

    pupPos = [leftfrm+pupHoff  butfrm+pupVoff pupWd pupHt ] ;
    pupSeg = uicontrol(...
         'Style','popup',...
        'Units','normalized', ...
         'Position',pupPos, ...
         'BackgroundColor',fgcolor,...
         'ForegroundColor',[0 0 0], ...
       'string','Fixed|Adaptive' );


        %====================================
        % Transform Bloc
    frmNb = 1;
    leftfrm = frmHspace+(frmWd+frmHspace)*frmNb;
    butfrm = 1-(frmVspace+frmWd);
    frmPos = [   leftfrm butfrm frmWd frmHt ];
    frmbox1 = uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
        'BackgroundColor',fgcolor);
    
    frmstr = 'Transform';
    txtPos = [leftfrm+pupHoff butfrm+pupVoff+pupHt-.02 pupWd pupHt ];
    frmtxt = uicontrol(...
        'Style','text', ...
        'Units','normalized', ...
        'Position',txtPos, ...
        'String',frmstr, ...
        'BackgroundColor',fgcolor);

    pupPos = [leftfrm+pupHoff  butfrm+pupVoff pupWd pupHt ] ;
    pupTra = uicontrol(...
         'Style','popup',...
        'Units','normalized', ...
         'Position',pupPos, ...
         'BackgroundColor',fgcolor,...
         'ForegroundColor',[0 0 0], ...
         'string','DCT|MLT|Ondelettes',...
         'Callback','CodDemo(''popupTra'')' );   % Value 0->DCT;  1->MLT; 2->Ondelettes.
         


        %====================================
        % Allocation Block
    frmNb = 2;
    leftfrm = frmHspace+(frmWd+frmHspace)*frmNb;
    butfrm = 1-(frmVspace+frmWd);
    frmPos = [   leftfrm butfrm frmWd frmHt ];
    frmbox1 = uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
        'BackgroundColor',fgcolor);
    
    frmstr = 'Allocation';
    txtPos = [leftfrm+pupHoff butfrm+pupVoff+pupHt-.02 pupWd pupHt ];
    frmtxt = uicontrol(...
        'Style','text', ...
        'Units','normalized', ...
        'Position',txtPos, ...
        'String',frmstr, ...
        'BackgroundColor',fgcolor);

    pupPos = [leftfrm+pupHoff  butfrm+pupVoff pupWd pupHt ] ;
    pupAll = uicontrol(...
         'Style','popup',...
        'Units','normalized', ...
         'Position',pupPos, ...
         'BackgroundColor',fgcolor,...
         'ForegroundColor',[0 0 0], ...
         'string','NRJ|Psycho' );
 
     %
     %  2nd Block Line
     %
        %====================================
        % Output Bloc
    frmNb = 0;
    leftfrm = frmHspace+(frmWd+frmHspace)*frmNb;
    butfrm = 1-2*(frmVspace+frmWd);
    frmPos = [   leftfrm butfrm frmWd frmHt ];
    frmbox1 = uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
        'BackgroundColor',bgcolor);
    
    frmstr = 'Output';
    txtPos = [leftfrm+pupHoff butfrm+pupVoff+pupHt-.02 pupWd pupHt ];
    frmtxt = uicontrol(...
        'Style','text', ...
        'Units','normalized', ...
        'Position',txtPos, ...
        'ForegroundColor',[1 1 1], ...
        'String',frmstr, ...
        'BackgroundColor',bgcolor);

    pupPos = [leftfrm+pupHoff  butfrm+pupVoff pupWd pupHt ] ;
    
    callbackStr = 'CodDemo(''encode'')';
    pusOut = uicontrol(...
         'Style','push',...
        'Units','normalized', ...
         'Position',pupPos, ...
          'BackgroundColor',fgcolor,...
         'ForegroundColor',[0 0 0], ...
        'String','Encode', ...
        'Callback',callbackStr );


    
        %====================================
        % Entropy Bloc
    frmNb = 1;
    leftfrm = frmHspace+(frmWd+frmHspace)*frmNb;
    butfrm = 1-2*(frmVspace+frmWd);
    frmPos = [   leftfrm butfrm frmWd frmHt ];
    frmbox1 = uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
        'BackgroundColor',fgcolor);
    
    frmstr = 'Entropy';
    txtPos = [leftfrm+pupHoff butfrm+pupVoff+pupHt-.02 pupWd pupHt ];
    frmtxt = uicontrol(...
        'Style','text', ...
        'Units','normalized', ...
        'Position',txtPos, ...
        'String',frmstr, ...
        'BackgroundColor',fgcolor);

    pupPos = [leftfrm+pupHoff  butfrm+pupVoff pupWd pupHt ] ;
    pupEnt = uicontrol(...
         'Style','check',...
        'Units','normalized', ...
         'Position',pupPos, ...
          'BackgroundColor',fgcolor,...
         'ForegroundColor',[0 0 0], ...
       'string','Zip code?' );


        %====================================
        % Quantization Block
    frmNb = 2;
    leftfrm = frmHspace+(frmWd+frmHspace)*frmNb;
    butfrm = 1-2*(frmVspace+frmWd);
    frmPos = [ leftfrm butfrm frmWd frmHt ];
    frmbox1 = uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
        'BackgroundColor',fgcolor);
    
    frmstr = 'Quantization';
    txtPos = [leftfrm+pupHoff butfrm+pupVoff+pupHt-.02 pupWd pupHt ];
    frmtxt = uicontrol(...
        'Style','text', ...
        'Units','normalized', ...
        'Position',txtPos, ...
        'String',frmstr, ...
        'BackgroundColor',fgcolor);

    pupPos = [leftfrm+pupHoff  butfrm+pupVoff pupWd pupHt ] ;
    pupQua = uicontrol(...
         'Style','popup',...
        'Units','normalized', ...
         'Position',pupPos, ...
           'BackgroundColor',fgcolor,...
         'ForegroundColor',[0 0 0], ...
       'string','Uniform|Mu Law|(Vector)' );

    
    %====================================
    % The OPENFILE button
    BtnNb = 1;
    yPos=menutop-(BtnNb-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHt btnWid btnHt];

    labelStr='OpenFile';
    callbackStr='CodDemo(''openfile'')';
    recHndl=uicontrol( ...
        'Style','push', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'BackgroundColor',fgcolor, ...
        'String',labelStr, ... 
        'Callback',callbackStr);


    %====================================
    % The PLAY button
    BtnNb = 2;
    yPos=menutop-(BtnNb-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHt btnWid btnHt];

    labelStr='Play';
    callbackStr='CodDemo(''play'')';
    playHndl=uicontrol( ...
        'Style','push', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'BackgroundColor',fgcolor, ...
        'String',labelStr, ...
        'Callback',callbackStr);


    %====================================
    % The PLAY SYNT button
    BtnNb = 3;
    yPos=menutop-(BtnNb-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHt btnWid btnHt];

    labelStr='Play Synt';
    callbackStr='CodDemo(''playsynt'')';
    playHndl=uicontrol( ...
        'Style','push', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'BackgroundColor',fgcolor, ...
        'String',labelStr, ...
        'Callback',callbackStr);
     
    
    
    %====================================
    % The SAVE SYNT button
    BtnNb = 4;
    yPos=menutop-(BtnNb-1)*(btnHt+spacing);
    btnPos=[left yPos-btnHt btnWid btnHt];

    labelStr='Save Synt';
    callbackStr='CodDemo(''save'')';
    saveHndl=uicontrol( ...
        'Style','push', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'BackgroundColor',fgcolor, ...
        'String',labelStr, ...
        'Callback',callbackStr);
     
    
    %===================================
    % WINDOW LENGTH
    top = yPos - btnHt - spacing;
    labelWidth = frmWidth-textWidth-.01;
    labelBottom=top-textHeight;
    labelLeft = left;
    labelRight = left+btnWid;
    labelPos = [labelLeft labelBottom labelWidth textHeight];
    h = uicontrol( ...
	'Style','text', ...
        'Units','normalized', ...
	'Position',labelPos, ...
        'Horiz','left', ...
        'String','N Window', ...
        'Interruptible','off', ...
	'BackgroundColor',[0.5 0.5 0.5], ...
        'ForegroundColor','white');

    % Text field
    textPos = [labelRight-textWidth labelBottom textWidth textHeight];
    callbackStr = 'CodDemo(''lwindow'')';
    lfenHndl = uicontrol( ...
	'Style','edit', ...
        'Units','normalized', ...
	'Position',textPos, ...
	'Horiz','right', ...
	'Background','white', ...
        'Foreground','black', ...
	'String','512','Userdata',512, ...
        'callback',callbackStr);
    
    %===================================
    % CEL STEP
    top = yPos - 2*btnHt - 2*spacing;
    labelWidth = frmWidth-textWidth-.01;
    labelBottom=top-textHeight;
    labelLeft = left;
    labelRight = left+btnWid;
    labelPos = [labelLeft labelBottom labelWidth textHeight];
    
    h = uicontrol( ...
	'Style','text', ...
        'Units','normalized', ...
	'Position',labelPos, ...
        'Horiz','left', ...
        'String','Step :', ...
        'Interruptible','off', ...
	'BackgroundColor',[0.5 0.5 0.5], ...
        'ForegroundColor','white');

    % Text field
    textPos = [labelRight-textWidth labelBottom textWidth textHeight];
    callbackStr = 'CodDemo(''step'')';
    stepHndl = uicontrol( ...
	'Style','edit', ...
        'Units','normalized', ...
	'Position',textPos, ...
	'Horiz','right', ...
	'Background','white', ...
        'Foreground','black', ...
	'String','128','Userdata',128, ...
        'callback',callbackStr);

    %===================================
    % COMPRESSION FACTOR
    
    top = yPos - 3*btnHt - 3*spacing;
    labelWidth = frmWidth-textWidth-.01;
    labelBottom=top-textHeight;
    labelLeft = left;
    labelRight = left+btnWid;
    labelPos = [labelLeft labelBottom labelWidth textHeight];
    
    h = uicontrol( ...
	'Style','text', ...
        'Units','normalized', ...
	'Position',labelPos, ...
        'Horiz','left', ...
        'String','Compression x', ...
        'Interruptible','off', ...
	'BackgroundColor',[0.5 0.5 0.5], ...
        'ForegroundColor','white');

    % Text field
    textPos = [labelRight-textWidth labelBottom textWidth textHeight];
    callbackStr = 'CodDemo(''compression'')';
    fcHndl = uicontrol( ...
	'Style','edit', ...
        'Units','normalized', ...
	'Position',textPos, ...
	'Horiz','right', ...
	'Background','white', ...
        'Foreground','black', ...
	'String','10','Userdata',10, ...
        'callback',callbackStr);

    %===================================
    % WPD DEPTH
    
    top = yPos - 4*btnHt - 4*spacing;
    labelWidth = frmWidth-textWidth-.01;
    labelBottom=top-textHeight;
    labelLeft = left;
    labelRight = left+btnWid;
    labelPos = [labelLeft labelBottom labelWidth textHeight];
    
    h = uicontrol( ...
	'Style','text', ...
        'Units','normalized', ...
	'Position',labelPos, ...
        'Horiz','left', ...
        'String','Profondeur Wvlt', ...
        'Interruptible','off', ...
	'BackgroundColor',[0.5 0.5 0.5], ...
        'ForegroundColor','white');

    % Text field
    textPos = [labelRight-textWidth labelBottom textWidth textHeight];
    callbackStr = 'CodDemo(''WPDdepth'')';
    DHndl = uicontrol( ...
	'Style','edit', ...
        'Units','normalized', ...
	'Position',textPos, ...
	'Horiz','right', ...
	'Background','white', ...
        'Foreground','black', ...
	'String','6','Userdata',6, ...
        'callback',callbackStr);

    top = labelBottom - textHeight;

    %====================================
    % The CHOOSE WAVELET POPUP MENU
    Ypos = top - spacing;
    btnPos=[left Ypos-btnHt+spacing btnWid btnHt];
    txtPos=[left Ypos btnWid btnHt];

    labelStr= [ 'Haar         |Beylkin       |' ...
                'Coiflet      1|Coiflet      2|Coiflet      3|'...
                'Coiflet      4|Coiflet      5|' ...
                'Daubechies   4|Daubechies   8|' ...
                'Daubechies  12|Daubechies  16|Daubechies  20|' ...
                'Symmlet      4|Symmlet      5|Symmlet      6|'...
                'Symmlet      7|Symmlet      8|Symmlet      9|'...
                'Symmlet     10|Vaidyanathan  |'... 
                'QMF         12|QMF         16|QMF         32|'...
                'QMF         48|QMF         64' ];

   uicontrol('Style','text', ...
             'Units','normalized', ...
             'Position',txtPos, ...
             'BackgroundColor',[.5 .5 .5], ...
             'ForegroundColor','white', ...
             'String','Choose Wavelet');
   
    callbackStr='CodDemo(''choosewave'')';
    choosewaveHndl=uicontrol( ...
        'Style','popup', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'BackgroundColor',fgcolor, ...
        'String',labelStr, ...
        'Callback',callbackStr);

   %====================================
    % The INFO button
    labelStr='Info';
    callbackStr='CodDemo(''info'')';
    helpHndl=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
 	'BackgroundColor',fgcolor, ...
        'Position',[left frmBottom+btnHt+spacing btnWid btnHt], ...
        'String',labelStr, ...
        'Callback',callbackStr);

 
    %====================================
    % The CLOSE button
    labelStr='Close';
    callbackStr='close(gcf)';
    closeHndl=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
 	'BackgroundColor',fgcolor, ...
        'Position',[left frmBottom btnWid btnHt], ...
        'String',labelStr, ...
        'Callback',callbackStr);
  
  
    t = (0:length(signal)-1)/Fs;
    axes(ax1Hndl)
    plot(t,signal)
    set(gca,'Ylim',[min(signal)*1.1 max(signal)*1.1])
    title([  'Diapason, Fs : ' num2str(Fs) ])

    HndlList = [ ax1Hndl pupSeg pupTra pupAll pupQua pupEnt ...
                 lfenHndl stepHndl fcHndl DHndl choosewaveHndl ];



%========================================================
%                        ACTIONS
%========================================================

%========================================================
%                        OPENFILE
elseif strcmp(action,'openfile')
      [fname,pathname] = uigetfile({'*.au';'*.wav'},'Choose an audio AU or WAV file:');
      Nomsig = fname;
      lf = length(fname);

      if ~isequal(fname,0) & ~isequal(pathname,0)
        if strcmp(fname(lf-2:lf),'.au'), 
           [Nech,Nchan] = auread([pathname,fname],'size'); 
           [signal,Fs,Nbts] = auread([pathname,fname]);
        end
        if strcmp(fname(lf-3:lf),'.wav'), 
           filetype = 'WAV' ;
           [signal,Fs,Nbts] = wavread([pathname,fname]);
           [Nech,Nchan] = size(signal);
        end
           if Nchan > 1, 
             signal = signal(:,1); 
           end
        %    signal = (2^Nbts)*signal';
  
        soundsc(signal,Fs);
        n = nextpow2(signal);
        if 2^n ~= Nech
            signal = [signal(:) ; zeros(2^n-Nech,1)];
            Nech = 2^n;
        end
        t = (0:length(signal)-1)/Fs;
        axes(HndlList(1))
        plot(t,signal)
        set(gca,'Ylim',[min(signal)*1.1 max(signal)*1.1])
        title([ 'Fichier : ' fname ', Longueur : ' num2str(Nech) ...
                ' chant., Fs : ' num2str(Fs)])
    else
        msgbox('File not found, be sure that path is known by Matlab')
    end


%========================================================
elseif strcmp(action,'play')
      soundsc(signal,Fs);

%========================================================
elseif strcmp(action,'playsynt')
      soundsc(sigsynt,Fs);

%========================================================
elseif strcmp(action,'save')
    
     savename = [ 'sigsynt' num2str(savecount) ];
     savecount = savecount + 1;
     eval([ savename '= sigsynt;'])
     eval([  'save ' savename ' ' savename ])  
     disp([ 'Signal saved in ' savename ])
     
%========================================================
elseif strcmp(action,'lwindow'),
    v = get(gco,'String');
    v = eval(v);
    set(gco,'Userdata',v,'String',num2str(v))

%========================================================
elseif strcmp(action,'step'),
    v = get(gco,'String');
    v = eval(v);
    set(gco,'Userdata',v,'String',num2str(v))

%========================================================
elseif strcmp(action,'compression'),
    v = get(gco,'String');
    v = eval(v);
    set(gco,'Userdata',v,'String',num2str(v))

%========================================================
elseif strcmp(action,'WPDdepth'),
    v = get(gco,'String');
    v = eval(v);
    set(gco,'Userdata',v,'String',num2str(v))

%========================================================
% Suivant la transforme, mise a jour des choix possibles
elseif strcmp(action,'popupTra'),
    v = get(HndlList(3),'Value');
    pupSeg = HndlList(2);
    pupAll = HndlList(4);
    al = get(pupAll,'Value');
    se = get(pupSeg,'Value');
    switch v
       case 1  % DCT
          set(pupSeg,'String','Fixed|Adaptive','Value',se)
          if al > 2
             set(pupAll,'Value',2);
          end
          set(pupAll,'String','NRJ|Psycho')
          
       case 2  % MLT
          set(pupSeg,'String','Fixed','Value',1)
          if al > 2
             set(pupAll,'Value',2);
          end
          set(pupAll,'String','NRJ|Psycho')
       
       case 3  % Ondelettes
          set(pupSeg,'String','Fixed|Adaptive','Value',se)
          set(pupAll,'String','NRJ|Psycho|MiXeD')
    end


%========================================================
elseif strcmp(action,'choosewave')
    wavestr = get(HndlList(11),'String');
    val = get(HndlList(11),'Value');
    
    if val <= 20
       wavestr = wavestr(val,:);
       type = wavestr(1:end-2);
       type(find(type==' ')) = [];
       par = str2num(wavestr(end-1:end));
       qmf = MakeONFilter(type,par);
    else 
       matQMF = makematQMF;
       qmf =  matQMF(val-20,1:str2num(wavestr(val,end-1:end)));
    end
       
%========================================================
%                        ENCODE
elseif strcmp(action,'encode')
    
    point = choosepointer;
    set(gcf,'pointer','custom','pointershapecdata',point)
    
    % Rcupration des valeurs des popups
     seg = get(HndlList(2),'Value');
     tra = get(HndlList( 3),'Value');
     alo = get(HndlList( 4),'Value');
     qua = get(HndlList( 5),'Value');
     lfen = get(HndlList(7),'Userdata');
     pas = get(HndlList(8),'Userdata');
     Fc = get(HndlList(9),'Userdata');
     D = get(HndlList(10),'Userdata');
     
    % Fonction ralisant le choix entre les codeurs
     [sigsynt,sigcomp] = ChooseCoder(signal,lfen,pas,Fc,seg,tra,alo,qua,Fs,D,qmf,HndlList(1));
     
    % temporal segmentation
     nb = get(HndlList(2),'Value');
     if nb == 1
         strsynt = 'fix';
     elseif nb == 2
         strsynt = 'ada';
     end
     
     % Transform
     nb = get(HndlList(3),'Value');
     if nb == 1
         strsynt = [ strsynt '_dct'];
     elseif nb == 2
         strsynt = [ strsynt '_mlt'];
     elseif nb == 3
         strsynt = [ strsynt '_ond'];
     end
  
     % Allocation
     nb = get(HndlList(4),'Value');
     if nb == 1
         strsynt = [ strsynt '_nrj'];
     elseif nb == 2
         strsynt = [ strsynt '_rsm'];
     end

     % Quantization
     nb = get(HndlList(5),'Value');
     if nb == 1
         strsynt = [ strsynt '_uni'];
     elseif nb == 2
         strsynt = [ strsynt '_mul'];
     end

     % Entropy
     nb = get(HndlList(6),'Value');
     if nb == 0
         strsynt = [ strsynt '_comp'];
     elseif nb == 1
         strsynt = [ strsynt '_zipc'];
     end
     
     axes(HndlList(1))
      cla;
        t = (0:length(signal)-1)/Fs;
        t1 = (0:length(sigsynt)-1)/Fs;
        plot(t,signal,'b',t1,sigsynt,'r')
     set(gca,'Ylim',[min(signal)*1.1 max(signal)*1.1])
     set(gca,'Xtick',(sigcomp(1).seg)/Fs)
     title([ 'Fichier : ' fname ', Longueur : ' num2str(length(signal)) ...
                ' chant., Fs : ' num2str(Fs)])
     legend('Orig.','Synt.')
     grid on     
     zoom on
             
     set(gcf,'pointer','arrow')
     CodDemo('playsynt')

%========================================
%  INFO IS ASSUMED TO BE THE LAST ACTION
elseif strcmp(action,'info')
    set(gcf,'pointer','arrow')
    ttlStr = get(gcf,'Name');
	hlpStr1 = [ ...
                 ' This demo is ment to present you differents existing '
                 ' coding scheme.                                       '
                 ' The control Panel represents the different blocks    '
                 ' of a coder.                                          '
                 ' How does it work ?                                   '
                 '                                                      '
                 ' Just choose for any block of the coding chain        '
                 ' within the possible tools listed in the different    '
                 ' PopUp Menus and then encode the output.              '
                 '                                                      '
                 ' You can also change the compression factor in the    '
                 ' editable text box in the right frame and hear the    '
                 ' degradation of quality relative to its incrementation'
                 '                                                      '
                 ' To listen to the result and to the orignal           '
                 ' signal, just use the play buttons in the right frame '
                 '                                                      '
                 ' The open file button allows you to choose the file   '
                 ' you want to compress : it can be a WAV file (windows)'
                 '   or an AU file (unix). Other formats are not        '
                 '     supported                                        '
                 '                                                      '
                 '                                                      '];
		 
	hlpStr2 = [ ...
                '                                                        '
                ' Gilles Gonon - 09/01/2001                              '                                
                '                                                        '];

    myFig = gcf;
    helpfun(ttlStr,hlpStr1,hlpStr2);
    return  % avoid fancy, self-modifying code which
    % is killing the callback to this window's close button
    % if you press the info button more than once.
    % Also, a bug on Windows MATLAB is killing the 
    % callback if you hit the info button even once!

end
    

% ------------------------------------------------------------------------- %
function matqmf = makematQMF;
    % Fonction contenant les coefficients de filtres QMF,
    % rangs dans la matrice de sortie
    matqmf = zeros(64,64);
    
    % Modle A
	% 12 coefficients
		qmf12A = [ 0.4843894 .88469920e-1 -.8469594e-1 -.271326e-2 ...
			.1885659e-1 -.3809699e-2 ];
		qmf12A = sqrt(2) * [reverse(qmf12A) qmf12A ];
		
	% 16 coefficients
		qmf16A = [ .4810284 .9779817e-1 -.9039223e-1 -.9666376e-2 ...
			.276414e-1 -.2589756e-2 -.5054526e-2 .1050167e-2];
		qmf16A = sqrt(2) * [ reverse(qmf16A) qmf16A];
		
    % Modle E
	% 32 coefficients
		qmf32E = [ .4596455 .1387642 -.9768379e-1 -.5138257e-1 ...
			.5570721e-1 .2662431e-1 -.3830613e-1 -.14569e-1 ...
			.28122559e-1 .7379886e-2 -.2103823e-1 -.26120410e-2 ...
			.1568082e-2 -.9624592e-3 -.1127565e-1 -.5123228e-2];
		qmf32E = sqrt(2) * [ reverse(qmf32E) qmf32E];
	% 48 coefficients
		qmf48E = [ .45811759 .1408237 -.9672791e-1 -.5399054e-1 ...
			.5530728e-1 .2967508e-1 -.3844223e-1 -.1803938e-1 ...
			.2881379e-1 .1116025e-1 -.2228569e-1 -.6696168e-2 ...
			.1743719e-1 .3624247e-2 -.1359329e-1 -.1504938e-2 ...
			.1045324e-1 .25450090e-4 -.7852755e-2 .9912464e-3 ...
			.5644787e-2 -.1690987e-2 -.37667050e-2 .2540429e-2];
		qmf48E = sqrt(2) * [ reverse(qmf48E) qmf48E];

	% 64 coefficients
		qmf64 = [.46009810 0.1382363 -.9777076e-1 -.5095487e-1 ...
	.55432450e-1 .26447e-1 -.3764973e-1 -.1485397e-1 ...
	.2716055e-1 .828756e-2 -.1994365e-1 -.4313674e-2 ...
	.1459396e-1 .1894714e-2 -.1050689e-1 -.48579350e-3 ...
	.7367171e-2 -.2584767e-3 -.4989147e-2 .5743159e-3 ...
	.3235877e-2 -.6243724e-3 -.1986177e-2 .5308539e-3 ...
	.113826e-2 -.3823631e-3 -.5953563e-3 .2298438e-3 ...
	.2790277e-3 -.1104589e-3 -.1123515e-3 .3596189e-4 ];
	
		qmf64 = sqrt(2) * [ reverse(qmf64) qmf64 ];
		

    matqmf(1,1:12) = qmf12A;
    matqmf(2,1:16) = qmf16A;
    matqmf(3,1:32) = qmf32E;
    matqmf(4,1:48) = qmf48E;
    matqmf(5,1:64) = qmf64;

% Fin fonction makematQMF
% -------------------------------------------------------------------------- %


% ------------------------------------------------------------------------- %
function pointer = choosepointer;
   % Fonction de choix alatoire des pointeurs

   % for k=1:16, fprintf('%g  ',skull(k,:)), fprintf(';... \n'), end

   choix = ceil(rand(1)*3);
   if choix == 1,
   pointer = [ NaN  NaN  NaN  NaN  1  1  1  1  1  1  NaN  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  1  2  2  2  2  2  2  1  1  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  1  2  2  2  2  2  2  2  2  1  1  NaN  NaN  NaN  ;... 
   NaN  1  2  2  2  2  1  1  2  2  2  2  1  1  NaN  NaN  ;... 
   NaN  1  2  2  2  2  1  1  2  2  2  2  1  1  1  NaN  ;... 
   1  2  2  2  2  2  2  2  2  2  2  2  1  1  1  NaN  ;... 
   1  2  2  2  2  2  2  2  2  2  2  1  1  1  1  1  ;... 
   1  2  2  2  2  2  2  2  2  1  1  1  1  1  1  1  ;... 
   2  2  2  2  2  2  2  1  1  1  1  1  1  1  1  1  ;... 
   1  2  2  2  2  1  1  1  1  1  1  1  1  1  1  1  ;... 
   1  2  2  2  1  1  1  1  1  1  1  1  1  1  1  NaN  ;... 
   NaN  1  2  2  1  1  1  1  2  2  1  1  1  1  1  NaN  ;... 
   NaN  1  2  2  1  1  1  1  2  2  1  1  1  1  NaN  NaN  ;... 
   NaN  NaN  1  2  2  1  1  1  1  1  1  1  1  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  1  2  2  1  1  1  1  1  1  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  1  1  1  1  1  1  NaN  NaN  NaN  NaN  NaN  NaN  ];

   elseif choix == 2,
   pointer = [ 2  1  1  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  1  1  NaN  NaN  NaN  ;... 
   1  1  1  NaN  NaN  NaN  1  1  NaN  NaN  NaN  1  1  1  NaN  NaN  ;... 
   1  1  1  NaN  NaN  1  2  2  1  NaN  NaN  1  1  1  NaN  NaN  ;... 
   2  2  1  1  1  2  2  2  2  1  1  1  2  2  NaN  NaN  ;... 
   NaN  NaN  2  1  2  2  2  2  2  2  1  2  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  1  1  1  2  2  1  1  1  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  1  2  1  2  2  1  2  1  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  1  2  2  2  2  2  2  1  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  1  2  2  2  2  1  NaN  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  1  2  1  1  2  1  NaN  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  1  1  2  2  2  2  1  1  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  1  1  NaN  1  2  2  1  2  1  1  1  1  1  NaN  ;... 
   1  1  1  1  NaN  NaN  1  1  NaN  NaN  2  1  1  1  1  NaN  ;... 
   1  1  1  2  NaN  NaN  NaN  NaN  NaN  NaN  NaN  1  1  1  2  NaN  ;... 
   2  1  1  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  1  1  2  NaN  NaN  ;... 
   2  1  1  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  2  2  NaN  NaN  NaN ]; 

   elseif choix == 3,
      pointer = [NaN  NaN  NaN  1  1  1  NaN  NaN  NaN  1  1  1  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  1  1  2  1  1  NaN  1  1  2  1  1  NaN  NaN  NaN  ;... 
   NaN  1  1  2  1  2  1  1  1  2  1  2  1  1  NaN  NaN  ;... 
   NaN  1  2  1  1  1  2  1  2  1  1  1  2  1  NaN  NaN  ;... 
   NaN  1  2  1  1  1  1  2  1  1  1  1  2  1  NaN  NaN  ;... 
   NaN  1  2  1  1  1  1  1  1  1  1  1  2  1  NaN  NaN  ;... 
   NaN  1  1  2  1  1  1  1  1  1  1  2  1  1  NaN  NaN  ;... 
   NaN  NaN  1  1  2  1  1  1  1  1  2  1  1  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  1  1  2  1  1  1  2  1  1  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  1  1  2  1  2  1  1  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  NaN  1  1  2  1  1  NaN  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  NaN  NaN  1  1  1  NaN  NaN  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  NaN  NaN  NaN  1  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  ;... 
   NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN  NaN ]; 

   end
   
% Fin fonction choosepointer
% -------------------------------------------------------------------------- %

    