function mat_dct = DCT_analysis(x,M)

% function mat_dct = DCT_analysis(x,M)
% permet d'analyser un signal par des DCT
% de longueur M 
% Le resultat est une matrice dont chaque ligne represente
% la DCT d'une tranche

% conversion de x en vecteur colonne
x = x(:);

N = length(x);

N_tranche = ceil(N/M);

nb_pad = 0;
if rem(N,M)
	nb_pad = M-rem(N,M);
end

% Ajout de zeros pour avoir un nombre entier de tranches
% de longueur M
x = [ x; zeros(nb_pad,1)];

% On separe les diffrentes tranches de x (1 a M, M+1 a 2M, ...)
xtranche = reshape(x,M,N_tranche);

mat_dct = transpose(dct(xtranche));