function mat_max_ssband = MAX_matssband(mat_coef,nb_band)

% function mat_max_ssband = MAX_matssband(Mat_coef,nb_band)
% Donne, pour les diffrentes sous bandes
%	- mat_max_ssband : le maximum de chaque sous-bande pour chaque tranche
%		-> lignes : diffrentes sous-bandes  
%		-> colonnes : diffrentes tranches analyses
%
% Les coefficients sont dans une matrice de type mat_DCT ou mat_MLT
% chaque ligne contient les coefs d'une tranche transforme.

mat_coef = transpose(mat_coef);

[N,N_tr] = size(mat_coef);
l_band = N/nb_band;

if rem(N,nb_band)
	disp('mauvais nombre de sous-bandes')
	mat_max_ssband = []
	return
end

mat_reshape = reshape(mat_coef,l_band,nb_band,N_tr);
mat_max_ssband = max(abs(mat_reshape));
mat_max_ssband = reshape(mat_max_ssband,nb_band,N_tr);
