function mat_mlt = MLT_analysis(x,M)

% function mat_mlt = MLT_analysis(x,M)
% permet d'analyser un signal par forward MLT
% de longueur M (les tranches de signal analyses 
% sont elles de longueurs 2M)
% Le resultat est une matrice dont chaque ligne represente
% la MLT d'une tranche

% conversion de x en vecteur colonne
x = x(:);

N = length(x);

% Gestion des bords, par ajout de zeros
x = [ zeros(M,1); x; zeros(M,1)];

% On separe les diffrentes tranches de x (1 a 2M, M a 3M, ...)

xtranche = buf2mat(x,2*M,M);

% noyaux de la MLT
noy_mlt = noyMLT(M);

mat_mlt = transpose(noy_mlt * xtranche);
