function [matrupt,sigseg] = MakeSegWPD(signal,indrupt,D)

%
% Function [ Mat_Rupt, SigSeg ] = MakeSegWPD(signal,indrupt,D)
%
% Formats the rupture vector 'indrupt' derived from segmentation
% function (e.g. fastCEL2) to take into acount the 
% slight recovery for the depht D WPD of each 
% frame.
% 'indrupt' should include indice '0' and 'end' indice.
% MatRupt is a (N_frames x 2) matrix containing the 
% begining and ending indices of frame n_line.
% SigSeg is a cell array, of size (N_frames x 1)
%

recouv = 2^D/2;

signal = signal(:);
indrupt = indrupt(:);

% Dcalage
signalpad = [ zeros(recouv,1); signal; zeros(recouv,1) ];
indrupt = indrupt+recouv ;

matrupt = repmat(indrupt,1,2);
matrupt(1:end-1,1) = matrupt(1:end-1,1)  - recouv + 1;
matrupt(1:end-1,2) = matrupt(2:end,2) + recouv ;
matrupt(end,:) = [];

nframes = size(matrupt,1) ;

sigseg = cell(1,nframes);

l_frames = matrupt(:,2) - matrupt(:,1) +1;

for k = 1:nframes
    [fen,D2] = fenWPD(l_frames(k),D);
    sigseg{k} = signalpad(matrupt(k,1):matrupt(k,2)) .* fen';
end

