function wpquant = Q_unifWP(wp,bpss,btree,visu)

% function packet_quant = Q_unifWP(wp,bpss,btree,]visu)
% Donne les coefficients quantifis pour chaque paquet de la 
% recherche de meilleure base.
% En fonction du nbre de bits trouvs dans allocmatRSMBB.
%
% wp : vecteur de taille N, longueur de la tranche analyse.
%      contient les paquets terminaux issus de BestBasis puis ExtractWP
%
% btree : Arbre de BestBasis, permet de dterminer quels sont les 
%         paquets terminaux
%
% bpss : vecteur 1xN_tr ou N_tr est le nombre de paquets
%
% visu : variable optionnelles de visualisation, pour comparer les paquets quantifis
%        des paquets originaux 
%        visu = 1 -> affichage, 0 par dfaut -> pas d'affichage

if nargin < 4
   visu = 0;
end

N = length(wp);
pkt_alloc = find(bpss>0);
n_pkt = length(pkt_alloc);

% recherche des paquets terminaux dans btree
nodee = tree2node(btree);
   d = nodee(:,1);
   b = nodee(:,2);
% Longueur de chaque tranche
l_node = N./2.^d;

% Quantification
wpquant = zeros(N,1);


% -------------------
% Choix de la mthode
method = 1;   % (c'est la seule qui marche)

if method == 1
    for k = 1:n_pkt
        n_bit = bpss(pkt_alloc(k));
        ind_pkts = packet(d(pkt_alloc(k)),b(pkt_alloc(k)),N);
        scalfact = max( abs(wp(ind_pkts)) );
        wpquant(ind_pkts) =  wp(ind_pkts) / scalfact * 2^(n_bit-1) ; 
        %signquant = sign(wpquant(ind_pkts));
        %wpquant(ind_pkts) = (floor(wpquant(ind_pkts)) + .5*signquant)/ 2^(n_bit-1) * scalfact;
        wpquant(ind_pkts) = round(wpquant(ind_pkts))/ 2^(n_bit-1) * scalfact;
    end 
elseif method == 2
   for k = bit_min : bit_max
      pkts = find(bpss==k);
      ind_pkts = zeros(sum(l_node(pkts)),1);
      i = 1;
      for p = 1:length(pkts)
          h = pkts(p);
          npack = 2^d(h);
          ind_pkts(i:l_node(h)+i) =  ( (b(h) * (N/npack) + 1) : ( (b(h)+1) *(N/npack) ) )' ;
          i = i+l_node(h) + 1;
      end
      scalfact = max( abs(wp(ind_pkts)) );
      wp(ind_pkts) =  wp(ind_pkts) / scalfact * 2^(k-1) ;
      wpquant(ind_pkts) = (ceil(wp(ind_pkts)) + floor(wp(ind_pkts)) ) /2;
      	  % On normalise pour avoir la bonne amplitude
      wpquant(ind_pkts) = wpquant(ind_pkts) / 2^(k-1) * scalfact;
   end
end

if visu == 1
   figure(2),
   clf
   plot(wp), hold on,
   plot(wpquant,'r')
   drawnow
end