function coef_quant = Q_unifmat(coef_ss_band,bpss)

% function coef_quant = Q_unifmat(coef_ss_band,bpss)
% Donne les coefficients quantifis pour chaque sous_bande.
% En fonction du nbre de bits trouvs dans allocmatRSM.
%
% coef_ss_band : matrice NxN_tr ou N est la taille de la transforme
%				et N_tr est le nombre de tranche analyse 
%
% bpss : matrice MxN_tr ou M est le nombre de sous bandes


[N,N_tr] = size(coef_ss_band);		% N nombre de coef/ tranche.
					% N_tr nombre de tranches.
[M,N_tr2] = size(bpss);			% M nombre de sous bandes.

if N_tr > N_tr2
	coef_ss_band = coef_ss_band(:,1:N_tr2);
	disp('entres non compatibles, trop de coefficients')
	N_tr = N_tr2;
elseif N_tr2 > N_tr
	bpss = bpss(:,1:N_tr);	
	disp('entres non compatibles, bpss trop grand')
end

coef_ss_band = reshape(coef_ss_band,N/M,M,N_tr);
coef_quant = zeros(N/M,M,N_tr);

scf = max(abs(coef_ss_band));
scf = reshape(scf,M,N_tr);

for t = 1:N_tr
	for k = find(bpss(:,t)' ~= 0)		% Pour chaque sous bande qui une alloc non nulle
	
		band_norm = coef_ss_band(:,k,t) / max( abs(coef_ss_band(:,k,t)) ) * 2^(bpss(k,t)-1);
		coef_quant(:,k,t) = (ceil(band_norm)+floor(band_norm)) / 2;
		
		  % pour les coef entiers (au moins le max) on ajoute ou
		  % on retranche suivant le cas la moiti du pas
		ind = find(coef_quant(:,k,t) == round(coef_quant(:,k,t)));
		coef_quant(ind,k,t) = coef_quant(ind,k,t) - sign(coef_quant(ind,k,t))/2;

		  % On normalise pour avoir la bonne amplitude
		coef_quant(:,k,t) = coef_quant(:,k,t)/2^(bpss(k,t)-1) * scf(k,t);
	end
end

coef_quant = reshape(coef_quant,N,N_tr);