function y = UpSample(x)
% UpSample -- Upsampling operator
%  Usage
%    u = UpSample(d) 
%  Inputs
%    d   1-d signal, of length n
%  Outputs
%    u   1-d signal, of length 2*n with zeros
%        interpolating alternate samples
%        u(2*i-1) = d(i), i=1,...,n
%
	n = length(x)*2;
	y = zeros(1,n);
	y(1:2:(n-1) )=x;

%
% Copyright (c) 1993. Iain M. Johnstone
%    
    
    
%   
% Part of WaveLab Version .701
% Built Tuesday, January 30, 1996 8:25:59 PM
% This is Copyrighted Material
% For Copying permissions see COPYING.m
% Comments? e-mail wavelab@playfair.stanford.edu
%   
    
