function [ss_band,coef] = allocMLT(signal,lfen,factcomp)

% function [ss_band,coef] = allocMLT(signal,lfen,fact_comp)
%  - Entrees :  signal : Matrices de courbes sur laquelle porte l'allocation (coef DCT)
%			 par exemple la matrice de MLT. taille (n_tr,lMLT)
%		lfen : taille des sous bandes (largeur des segments considrs
%			pour analyser la concentration d'nergie).
%		factcomp : facteur de compression (ex: 11 -> 1:11)
%  - Sorties :  ss_band : numero des sous-bandes conserves
%			  matrice de taille (n_tr,nb_ssband_gard'ees)
%		coef : 	  coefficients associs  ces ss bandes
%			  taille ( nb_ssband_gardees*lfen,n_tr)
% Il faut transmettre en info annexe le nombre total de sous_bandes
% ainsi que le nombre de points de la squence.
% Rq : utilise la fonction repart_nrj

% Infos sur le signal
[ n_tr, lMLT] = size(signal);
% nombre de sous bandes sur les tranches
nb_ssband = lMLT/lfen;

hist = repart_nrj(signal,lfen,0);

% On ne garde que nb_ssband/factcomp sous bandes 
nb_kept = floor(nb_ssband/factcomp);	% nombre de ss bandes gardes
if nb_kept < 2
	nb_kept = 1;
else
	nb_kept = nb_kept-1;
end

[trihist,ss_band] = sort(hist,2);

trihist(:,1:end-nb_kept) = [];
ss_band(:,1:end-nb_kept) = [];

% Construction du vecteur d'indices des coefs `a partir de sous-bande
ss_band_se = sur_ech((ss_band-1)*lfen+1,lfen);
for k = 2:lfen
   ss_band_se(:,k:lfen:end) = (ss_band-1)*lfen+k;
end
% On deroule la matrice de coef
sigligne = reshape(signal.',1,n_tr*nb_ssband*lfen);

% on deroule maitenant les pointeurs sur sous bandes
cte1 = nb_kept*lfen;
ind_coef = transpose( (0:n_tr-1) * lMLT );
ind_coef = reshape( (ss_band_se + ind_coef(:,ones(1,cte1)))',1,n_tr*cte1);

% Les coefs sont ranges dans une matrice
% 1. n lign : pour une tranche nligne sous bandes gardes (nb_kept*lfen)
% 2. n col : nombre de tranche analyses ( n_tr de la matrice d'entres)

coef = sigligne(ind_coef);

% On reforme la matrice
coef = reshape(coef,cte1,n_tr);