function bpss = allocSMRBB(wp,SMR,btree,Debit,Fe,visu)

% function bpss = allocSMRBB(wp,RSM,btree,Debit,Fe,]visu);
% Allocation rapide, globale,
% au pro-rata du rapport signal a masque
% pour les paquets issus.
% wp    : coef des Paquets (ncessaires pour le nombre de bit maximal)
% RSM   : Rapport signal a masque
% btree : arbre issu de BestBasis
% Debit : debit de compression
% Fe    : Frquence d'chantillonnage.
%
% visu : variable optionnelle de visualisation, pour voir en temps rel 
%        les bits se rpartir par rapport au courbes de masquage
%        visu = 1 -> affichage, 0 par dfaut -> pas d'affichage
%

if nargin < 6
   visu = 0;
end

% On interpole SMR pour faire la correspondance entre la longueur 
% de la tranche et la demi longueur du SMR.

N = length(SMR);
SMR = interp1(2:2:2*N,SMR,1:2*N);
N = 2*N;

% (On pondre quand mme les basses frquences) ??

% recherche des paquets terminaux dans btree
nodee = tree2node(btree);
n_node = size(nodee,1);

% Longueur de chaque tranche
l_node = N./2.^nodee(:,1);

% SMR pour chaque node
SMR_node = zeros(n_node,1);
% Maximum de bits ncessaires pour chaque sous-bande
maxbitwp = zeros(n_node,1); 

% Nbre de bits ncessaires pour chaque coef de wp
maxwp = max(abs(wp));
wpbit =  (abs(wp)/maxwp * 2^15 ) + eps ;

lim_pkt = nodee(:,2).*(N./2.^nodee(:,1)) + 1;
[val_lim_pkt,ind_pkt] = sort(lim_pkt);

for k = 1:n_node
    %  MAX ou MIN ou mean ???
    % Sur le Rapport signal a masque ou sur la courbe de masquage ???
    indSMR = packet(nodee(k,1),nodee(k,2),N);
    SMR_node(k) = max(SMR(floor(indSMR)));
    maxbitwp(k) = max(0, floor( log2( std(wpbit(indSMR)) )) +1);
end


% Nombre de bits dispo pour la tranche pour respecter le debit
bit_dispo_tranche = Debit/Fe * N;

% Initialisation de bpss
bpss = zeros(n_node,1) ;

if visu == 1
   figure(1),
     clf;
      subplot(211)
         plot(SMR)
         hold on,
         plot(lim_pkt,SMR_node,'ro')
         set(gca,'xlim',[0 N],'xtick',val_lim_pkt,'xgrid','on')
         title('Courbes de masquage')
      axhndl = subplot(212);
         set(axhndl,'Ylim',[0 16],'Xlim',[0 N],'drawmode','fast','ygrid','on');
         hold on
         ylabel('Bits'), xlabel('Paquets'),
         title('Allocation proportionnelle aux courbes de masquage')
         bar(val_lim_pkt,bpss(ind_pkt),'grouped','r:')

         bpsshndl = get(axhndl,'children');
         set(bpsshndl,'erasemode','xor')
           %ydata = get(bpsshndl,'YData');
         vertice = get(bpsshndl,'Vertice');
         face    = get(bpsshndl,'Faces');
         vertex  = get(bpsshndl,'facevertexcdata');
      set(gcf,'visible','on')
end

% On est oblig de faire bit  bit (et non par plan comme 
% pour la MLT) car les sous-bandes ne sont pas de mme longueur
% et la mise a jour du nombre de bit_dispos varie.
% L'affichage se fait en temps rel ;-)
  
while (bit_dispo_tranche > 0)
   [val,indmax] = max(SMR_node);
   if bpss(indmax) >= maxbitwp(indmax)
      SMR_node(indmax) = -1000;
   else
      bpss(indmax) = bpss(indmax) + 1;
      % L'allocation de 1 bit entraine la diminution du SMR de 6dB
      % et la diminution du nombre de bit dispo du nombre d'chantillon
      % dans le paquet.
      SMR_node(indmax) = SMR_node(indmax) - 6 ;  
      bit_dispo_tranche = bit_dispo_tranche - l_node(indmax);
%     ydata(2:3,:) = repmat(bpss(ind_pkt)',2,1);
      if visu == 1
         vertice(3:5:end,2) = bpss(ind_pkt);
         vertice(4:5:end,2) = bpss(ind_pkt);

         set(bpsshndl,'Vertice',vertice,'faces',face,'facevertexcdata',vertex),
         drawnow
      end
   end
end