function bpss = allocmatRSM(mat_smr,factcomp,max_ssband,lfen)

% function bpss = allocmatRSM(mat_smr,factcomp,max_ssband,lfen)
% Allocation psychoacoustique des ressources binaire
% pour compresser le signal d'un facteur factcomp.
% Entres : 
% - mat_smr : Matrice issue de 'maxmasqmat' contenant les valeurs
% 	  du smr de chaque tranche analyse
% - factcomp : facteur de compression souhait
% - max_ssband : vecteur contenant les maxima des diffrentes 
% 		sous bandes, utilis pour obtenir le nombre max de bits/ssb
%
% - lfen : longueur de la fenetre transforme.
% Sorties :
% - bpss : matrice contenant pour chaque tranche (en ligne)
% 	   le nombre de bit assign  chaque sous bande.

% Variable de VISUALISATION pour les courbes.
global VISU

% Nombre de sous-bandes et nombre de tranches analyses
[ M,N_tr ] = size(mat_smr);

% ----------------------------------------------------------------
% Ressources disponibles en fonction du facteur de compression
% souhait
% si les chantillons sont cods sur 16 bits
% ----------------------------------------------------------------
bit_dispo_tranche = lfen * 16 / factcomp;

% Nombre de coef par sous - bande pour respecter le debit
nb_coef_p_ssbnd = lfen/M;

%bit_dispo_ssband = bit_dispo_tranche/ nb_coef_p_ssbnd;



% On dcale toute la courbe
% pour allouer toutes les sous bandes.
	min_smr = min(mat_smr);
	mat_smr = mat_smr - min_smr(ones(1,M),:);

% 1 BIT -> 6 dB
% ON divise la courbe par 6 pour avoir le RSM en bits
%
% on garde des nombres reels (et non entier)
% pour le tri de la redistribution de bits.

bpss = zeros(M,N_tr);
mat_smr = mat_smr / 6;

% Pour chaque tranche meme nombre de bits disponibles au depart
bit_dispo = ones(1,N_tr)*bit_dispo_tranche;
% -------------------------------------------------------------
  for k=1:N_tr
% ------------

   RSM = mat_smr(:,k);
   % mme procdure que pour allocRSM2 pour chaque tranche

	if (sum(RSM)*nb_coef_p_ssbnd) <= bit_dispo(k)
		bpss(:,k) = RSM;
		disp('Il reste des bits disponibles !!')
	else 	level = round(max(RSM));
		while ( sum(bpss(:,k))*nb_coef_p_ssbnd <= bit_dispo(k) )
			bpss(find(RSM > level),k) = RSM( find(RSM > level) ) - level;
			level = level - 1;
%			if VISU == 1
%				clf
%				plot(RSM);hold on;plot(level*ones(1,M),'r')
%				plot(level*ones(1,M)+1,'w')
%				bar(bpss(:,k),'k')
%				title([ 'SMR tranche n^o ' num2str(k) ])
%				pause(1)
%			end
		end
	end
% ---
  end
% ---

% -------------------------------------------------
% Procdure traitant l'allocation en matrice
% ne marche pas (c'est normal pour l'instant)
% --------------------------------------------------
% Vecteur contenant les numeros des tranches a allouer
%num_tr = 1:N_tr; 
%
% On recherche si le smr pour certaines tranches 
% suffit a l'allocation (san distribution)
% normalement, ca n'arrive pas.
%
%bpss_direc = find(sum(mat_smr) <= bit_dispo);
%	bpss(bpss_direc,:) = mat_smr(bpss_direc,:);
%	disp([ 'Il reste des bits disponibles pour les tranches ' ...
%			num2str(bpss_direc) ])
%
%num_tr(bpss_direc) = [];
%bit_dispo(bpss_direc) = [];
%
% on alloue couche par couche les bits de meme importance (SMR)
%level = round(max(mat_smr));
%
%ind_tr = find(sum(bpss(num_tr)) <= bit_dispo)
%
%while ~isempty(ind_tr)
%	ind_tr2 = find(mat_smr(ind_tr) > level(ind_tr)) ;
%	bpss(ind_tr(ind_tr2)) = mat_smr(ind_tr(ind_tr2)) - level(ind_tr(ind_tr2));
%	level(ind_tr(ind_tr2)) = level(ind_tr(ind_tr2)) - 1;
%end
% --------------------------------------------------

%-----------------------------------------------------%
% On vrifie qu'il n'y pas de sous - bandes ayant plus
% de bit_max bits 
%------------------------------------------------------%

% Bit max par rapport  l'energie des diffrentes sous bandes

bit_max = ceil(log2(max_ssband+eps));
min_bitmax = min(bit_max);
indmin = find(min_bitmax<0);
for k = indmin
	bit_max(:,k) = bit_max(:,k) - min_bitmax(k);
end
bit_max(find(bit_max>16)) = 16;

%-------------------------------------------%
%     Procdure redistribuant les bits      %
% en trop par le simple calcul du pro rata  %
%-------------------------------------------%


  for k = 1:N_tr
% --------------

[bpsstri,indtri] = sort(bpss(:,k));

bit_maxtri = bit_max(indtri,k);

ind = find(bpsstri > bit_maxtri );
if ~isempty(ind)

	diffbpss = sum(bpsstri(ind)- bit_maxtri(ind) );
	bpsstri(ind) = bit_maxtri(ind) ;
	ptr1 = min(ind)-1;
	while (diffbpss>0 & ptr1 ~=0)
		if (bpsstri(ptr1)+diffbpss) > bit_maxtri(ptr1)  
         diffbpss = diffbpss - (bit_maxtri(ptr1) -bpsstri(ptr1));
         bpsstri(ptr1) = bit_maxtri(ptr1);
		  ptr1 = ptr1 -1;
%	if VISU == 1
%		clf
%		plot(bit_max(:,k));hold on
%		bar(bpsstri(indtri),'k')
%		title([ 'SMR tranche n^o ' num2str(k) ' bits a repartir ' num2str(diffbpss)])
%		pause(1)
%	end

		else 	bpsstri(ptr1) = bpsstri(ptr1)+diffbpss;
			diffbpss = 0;
		end
	end


end

bpss(indtri,k) = round(bpsstri);


  end
% ---
