function [mat,nzeros] = buf2mat(buf,np,shift,w)

% BUF2MAT Vector to matrix conversion, with shift abilities
% 	
% MAT = buf2mat(BUF,M,SHIFT)
%	converts vector BUF to be a M
%	column matrix . Each column 
%	of MAT is made with a M-long shift-version of SHIFT of BUF
%	
% 	MAT = buf2mat(BUF,M,SHIFT,W)
% 	windows each column by a specified window vector (of length M).

% Silvio Montresor

% Correction le 20/12/2000 GG pour un shift quelconque (> 50 %).
% Modif. le 21/06/2000 pour la 1re et derniere fenetre (1/2 fenetres)
% modif. le 9/11/2000 pour les problemes de shift non diviseurs de M

buf = buf(:)';
lenb = length(buf);

% On s'assure que shift est un multiple de np
shift = round(np / round(np/shift));

np2 = lcm(np,shift);
nb_shift = round(np2/shift) - 1;

% On garde la dernire tranche pleine
[ m2,nzeros ] = vec2mat(buf,np);
[ nl,nc ] = size(m2);

for k = 1:nb_shift
	m2 = [m2 , vec2mat([ buf(k*shift+1:lenb),zeros(1,k*shift) ],np) ];
end

[nlf,ncf] = size(m2);
mat = reshape(m2',np,ncf/np*nlf);

% On stoppe la matrice losque l'on arrive sur la dernire tranche pleine
% (donne par le premier vec2mat, nl tant le numro de la dernire 
%  tranche)
mat = mat(:, 1:( nl + nb_shift*(nl-1) ) );

if nargin==4,
   [ nl,nc ] = size(mat);
   w = w(:);
   w = w(:,ones(1,nc));
   w(1:nl/2,1) = 1;
   w(nl/2+1:nl,nc) = 1;
   mat = w.*mat;
end