function valeur = discretseuil(N,fe);

% function valeur = discretseuil(N,fe);
% discretise le seuil d'amplitude absolue pour le 
% comparer a la courbe de masquage en fonction du nombre
% de points analyss et de Fe (interpolation de la courbe)

% Valeurs pour le seuil absolu d'audition extraites de Zwicker
% 1ere ligne : f en Hz
% 2eme ligne : Niveau en dB

if N/2~=floor(N/2)
	disp('il faut un nombre pair d''chantillons en entre')
end
freq_seuil_abs = 1000*[ 0 0.02 0.028 0.05 0.075 0.1 0.15 0.2 0.31 0.5 ...
			1 2 2.5 3 3.6 4 4.5 5 6 7 8 9 10 11 12 12.5 14 17 22 22.05];
amp_seuil_abs = [ 72 72 60 40 30 25 20 16 10 6 2.5 0 -1 -4 -5 -4.5 -3 ...
			0 3 4 5 6 7.5 10 13 15.5 30 70 90 94];

[val,ind] = find(freq_seuil_abs<=fe/2);
freq_seuil_abs = freq_seuil_abs(ind);
amp_seuil_abs = amp_seuil_abs(ind);

% discretisation de ce vecteur a la rsolution du signal

% vect qui contient les valeurs en indice des points du seuil abs
indice = round(freq_seuil_abs * N / fe );

valeur = zeros(1,ceil(N/2));

[val,ind] = find(indice == 1);


for k = max(ind):length(indice)-1

% Approximation linaire (1er ordre)
		diff = (indice(k+1)-indice(k));
		if diff == 0
			diff = 1e-6;
		end
		pente = (amp_seuil_abs(k+1)-amp_seuil_abs(k)) / diff;
		offset = (amp_seuil_abs(k)*indice(k+1) - indice(k)*amp_seuil_abs(k+1))/ diff;
		valeur(indice(k):indice(k+1)) = pente * (indice(k):indice(k+1)) + offset;
end
	valeur(indice(end):ceil(N/2)) = amp_seuil_abs(end);
