function [ CEL, vectind,indpos ] = fastCEL2(x,N,pas,seuil,visu)

% function [ CEL, vectind,indpos ] = fastCEL2(x,N,pas,seuil,visu)
%	MY_RECUR calcule le cel du signal x(t)
%	de longueur Lx, avec des fenetres glissantes de taille N.
%	les fentres glissent de pas  chaque fois, pas tant 
% 	un multiple de la longueur des fentres.
% Entres
%	- x : vecteur.
%	- N : Taille des fentres d'analyse
%	- pas : pas de glissements des fentres
% 	- seuil : (defaut 25) seuil en % pour les coefficients
%	 conservs. Par rapport  la moyenne des valeurs positives du CEL
%	- visu : (default 1) variable de visualisation
%		0 -> pas de courbes ; 1 -> courbes
% Sorties
% 	- CEL : courbes du CEL aux points vectind.
%	- vectind : vecteur d'indices auxquels sont calculs le CEL
%	- indpos : indice positifs
% C'est le meme fichier que (find_CEL d'hlne bas sur "recur" de 
% Imad).


if nargin < 5
	visu = 1;
	if nargin < 4
		seuil = 25;
	end
end

x = x(:)/norm(x);
Lx = length(x);
pas = N / round(N/pas);
NS2 = N/2;


% Matrice des tranches (tranches de taille N)
[ xtranche,nzeros] = splitvec(x,N,pas);

vectind = (NS2:pas:Lx+nzeros-NS2);

% Matrice des demi tranches (tranches de taille N/2)
xdemitranche = splitvec([ x; zeros(nzeros,1) ],NS2,pas);

% On normalise les tranches et les demi tranches par rapport
% a la tranche
%normtranche = sqrt(sum(xtranche.^2));
%xtranche = xtranche ./ normtranche(ones(N,1),:);
%normtranchedemi = sqrt(sum(xdemitranche.^2));
%xdemitranche = xdemitranche ./ normtranchedemi(ones(NS2,1),:);


% 		 Calcul des FFT et des Entropies
% *****************************************************************

% Calcul des FFT et des entropies pour les demi tranches
TFxdemitranche = abs(fft(xdemitranche));
Entdemitranche = Entropie_X(TFxdemitranche / sqrt(NS2));

% Calcul des FFT pour les tranches
TFxtranche = abs(fft(xtranche));
Enttranche = Entropie_X(TFxtranche / sqrt(N));

% Calcul du CEL

Eg = Entdemitranche(1:end-NS2/pas);
Ed = Entdemitranche(NS2/pas+1:end);

norme = abs(Enttranche);
norme = norme.*(norme>0) + (norme==0);

CEL = (Enttranche - (Eg+Ed))./norme;

%CTEL = abs((Eg-Ed)/(Eg+Ed));

% On supprime le dernier point, perturb par les 0 ajouts
if nzeros ~= 0
	CEL(end) = [];
	vectind(end) = [];
end

% Partie positive du CEL.

moyCEL = mean(CEL);
stdCEL = std(CEL);
moymax = moyCEL+stdCEL;

if ~isempty(find(CEL>0))
	if moymax <= 0
		moyCEL2 = mean(CEL(find(CEL>0)));
	else
		moyCEL2 = mean(CEL(find(CEL<moymax & CEL>0)));
	end
else
	moyCEL2 = nan;
end

if ~isnan(moyCEL2)
	[celpos,ind] = find(CEL > moyCEL2*seuil/100);
	indpos = vectind(ind);
else
	disp('Pas de ruptures (signal stationnaire ou mauvais choix des paramtres)')
	celpos = [];
	indpos = [];
end

if visu == 1

	figure(1)
	clf
	plot(x)
	hold on; plot(vectind,CEL/max(CEL)*max(x),'m')
	stem(indpos,celpos*max(x),'g-o')
end