function bark = hz2bk(freq,dim)
% function bark = hz2bk(freq,dim)
% cette fonction calcule pour un vecteur
% en hertz les valeurs en bark correspondantes correspondantes
% dim: parametre optionnel pour la frequence
%	dim = 0 : f en kHz (par defaut)
%	dim = 1 : f en Hz

if nargin == 2
	if dim == 1 
		f0 = freq / 1000;  	% conversion en kHz
	else f0 = freq;
	end
else f0 = freq;
end

bark = 13 * atan(0.76 * f0) + 3.5 * atan((f0 / 7.5).^2);
