function [Mask,SMR,offset] = maxmasq(tranche,fe)

% fonction [Courb_Mask,SMR] = maxmasq(signal,fe)
% Implmentation des courbes de masquage
% Selon le livre de Nicolas Moreau p.140-150
% Reprend le masquage intgrs dans Mpeg audio
% Sorties : - Mask la courbe de masquage
% 	    - SMR le rapport signal  masque

N_tr = length(tranche);

% On vrifie que l'entre est un vecteur ligne
tranche = tranche(:)';

% Calcul de la DSP de la tranche (priodogramme)
% Du signal fenetr (par hanning)	
dsp_tr = 1/N_tr * (abs(fft(tranche.*(hanning(N_tr))'))).^2;

% Normalisation  96 dB, elle correspond en fait 
%  une translation en dB (et non une homothtie).

% fact_norm = 10^9.6 / max(dsp_tr);

% Passage en dcibel
dsp_db = 10 * log10( dsp_tr );
offset = 96 - max(dsp_db);
dsp_db = dsp_db + offset;

% Conversion en bark
axef = (0:N_tr/2-1) * fe/N_tr; % Axe des frquences 
axeb = hz2bk(axef,1);	  % Axe des Barks

% --------------------------------------------------
% Recherche des composantes tonales et non tonales
% leurs indices sont stocks dans Nn et Nt
% --------------------------------------------------
Nn = []; Nt = [];
% On spare les 3 cas possibles
% indices correspondant  4k et 8 kHz
ind4k = round(N_tr/fe*4000);
ind8k = round(N_tr/fe*8000);

% On garde de la reconnaissance des tonales du Mpeg
% avec une regle de 3, suivant Fe.
n1 = floor(2*fe/32000);
n2 = floor(3*fe/32000);
n3 = floor(6*fe/32000);

if n1 < 2
	n1 =2;
end
if n2 < 2
	n2 =2;
end
if n3 < 2
	n3 =2;
end

limite1 = floor([-n1:-2 2:n1]*fe/32000);
limite2 = floor([n2:-2 2:n2]*fe/32000);
limite3 = floor([-n3:-2 2:n3]*fe/32000);

% F dans [0,4kHz]
 for k = n2:ind4k-1 ;
	% Premires conditions
	if (dsp_db(k) >= dsp_db(k+1)  & ...
	    dsp_db(k) > dsp_db(k-1)   & ...
 	    dsp_db(k) - dsp_db(k + limite1) >=7 )
		Nt = [Nt k]; % c'est une tonale
 	else
		Nn = [Nn k];  % ca n'est pas une tonale
	end
end
% F dans [4,8kHz]
 for k = ind4k : ind8k ;
	% Premires conditions
	if (dsp_db(k) >= dsp_db(k+1)  & ...
	    dsp_db(k) > dsp_db(k-1)   & ...
	    dsp_db(k) - dsp_db(k + limite2) >=7)
		Nt = [Nt k]; % c'est une tonale
	else
		Nn = [Nn k];  % ca n'est pas une tonale
	end
end
% F dans [8,Fe/2kHz]
for k = ind8k : N_tr/2 - n3 ;
	% Conditions
	if (dsp_db(k) >= dsp_db(k+1)  & ...
	    dsp_db(k) >  dsp_db(k-1)  & ...
	    dsp_db(k) - dsp_db(k + limite3) >=7 )
		Nt = [Nt k]; % c'est une tonale
	else
		Nn = [Nn k];  % ca n'est pas une tonale
	end
end

nb_t = length(Nt);	% Nombre de tonales
nb_n = length(Nn);	% et de non tonales

% Renforcement de la puissance des tonales
dsp_db(Nt) = 10 * log10( 10.^(dsp_db(Nt-1)/10) + 10.^(dsp_db(Nt)/10) + ...
		10.^(dsp_db(Nt+1)/10) );
dsp_db(Nt-1) = -100;
dsp_db(Nt+1) = -100;

% Regroupement des tonales 
% Distante de moins de 0.5 Bark

ecart = abs(axeb(Nt(1:nb_t-1)) - axeb(Nt(2:nb_t)));
ind = find(ecart<0.5);

% Position des indices
% si posind > 0, la premire tonale est la plus forte
% si posind < 0, on limine la premire (son indice est donn par ind)
posind = dsp_db(Nt(ind)) < dsp_db(Nt(ind+1));
indneg = find(posind < 0);
ind(indneg) = ind(indneg) + 1;

Nt(ind) = [];

%for k= 1:length(ind)	% On elimine la moins puissante
%	if 
%      Nt(ind(k)) = [];
%      ind = ind-1;
%	else
%      Nt(ind(k)+1) = [];
%      ind = ind-1;
%	end
%end

% Regroupement des non tonales
% suivant les bandes critiques
%[limites,ecart] = band_critik(32000);
%dsp_Nn = zeros(1,24);
%for k = 1:length(limites)-1
%	ind = find( ( axef(Nn)>=limites(k) ) & (axef(Nn) < limites(k+1)) );
%	dsp_Nn(k) = 10*log10(sum(10.^(dsp_tr(ind)/10)));
%	Nn(ind(2:length(ind))) = []
%end
% --------------------------------------------------------
% Donnes pour les courbes de masquage
% --------------------------------------------------------
% Attention, il faut maintenant travailler en Barks
% par contre, faut-il travailler en dB ???
	
% Indices de masquage  la frquence considre
%	a_t = -1.525 - 0.275*axeb(Nn) - 4.5;	% pour les tonales
%	a_n = -1.525 - 0.175*axeb(Nt) - 0.5;	% pour les non tonales
	
% fonction de masquage
% --------------------------------------------------------
Mask = zeros(1,N_tr/2);

% On ajoute les indices de masquages
%Mask(Nt) = a_t;
%Mask(Nn) = a_n;

% On prend une valeur nulle pour Nt, au cas ou il n'y est pas de tonales
if isempty(Nt)
   Nt = 0;
end

for k = 1 : N_tr/2
	Etal = [];
	% On recherche l'talement : de -3  8 Barks
		f1 = axeb(k);	% Frequence ou l'on se situe en Bark
		P1 = dsp_db(k);
	% 1. f entre -3 <= f < -1
		ton1 = find((axeb>=f1-3) & (axeb<f1-1));
	Etal(ton1) =17*((axeb(ton1)-f1) +1) - (0.4* P1+ 6);

	% 2. f entre -1 <= f < 0
		ton2 = find((axeb>=f1-1) & (axeb<f1));
	Etal(ton2) = (0.4* P1 + 6) * ((axeb(ton2)-f1));

	% 3. f entre 0 <= f < 1
		ton3 = find((axeb>=f1) & (axeb<f1+1));
	Etal(ton3) = - 17 * ((axeb(ton3) - f1));

	% 4. f entre 1 <= f < 8
		ton4 = find((axeb>=f1+1) & (axeb<f1+8));
	Etal(ton4) = - ((axeb(ton4) - f1) - 1 )*(17 - 0.15*P1) - 17;
	vectind = [ton1 ton2 ton3 ton4 ];
	
	if sum(Nt==k)
		a_t = -1.525 - 0.275*axeb(k) - 4.5;	% pour les tonales
		Etal(vectind) = Etal(vectind) + P1 + a_t;
%		plot(Etal)
%		pause
	else
		a_n = -1.525 - 0.175*axeb(k) - 0.5;	% pour les non tonales
		Etal(vectind) = Etal(vectind) + P1 + a_n;
	end
% -------------------------------------------------------------------------------
% Au lieu d'ajouter les contributions des courbes, on dcide de ne garder
% que celle qui est maximale de manire  avoir une courbe forward - adaptative
% -------------------------------------------------------------------------------
%	Mask(vectind) = 10*log10(10.^(Mask(vectind)/10) + 10.^(Etal(vectind)/10));
% devient (par rapport a "funcmasq.m"):
	Mask(vectind) = max(Mask(vectind),Etal(vectind));
end

%n_fig = size(bandes,1);
%for k= 1 : n_fig
%	subplot(n_fig,1,k)
%	plot(bandes(k,:))
%	nom = [ 'bande' num2str(k) ];
%	auwrite(9*bandes(k,:),8000,[ './matlab/sons/' nom '.au'])
%end
%subplot(211)
%plot(axeb,Mask,'r',axeb,dsp_db(1:N_tr/2),'b')
%subplot(212)
%plot(axef,Mask,'r',axef,dsp_db(1:N_tr/2),'b')

% Prise en compte du seuil absolu d'audition

seuil_absolu = discretseuil(N_tr,fe);
Mask = max(seuil_absolu,Mask);

% On dnormalise le spectre
Mask = Mask - offset;

% Calcul du Rapport signal a masque
SMR = 10*log10(dsp_tr(1:N_tr/2))  - Mask;

