function [Mask,SMR] = maxmasqmat(signal,l_tr,recouv,fe)

% fonction [Courb_Mask,SMR] = maxmasqmat(signal,l_tr,recouv,fe)
% Implmentation des courbes de masquage
% Sur tous le signal, que l'on scinde
% en tranches  de taille l_tr, se recouvrant de recouv 
% 
% Sorties : - Mask la courbe de masquage de chaque tranche
% 	    - SMR le rapport signal  masque de chaque tranche

N = length(signal);
signal = signal(:);

% Mise en forme signal -> matrice
fen = hanning(l_tr);
if recouv ~= 0
	signal = [ zeros(l_tr/2,1) ; signal ; zeros(l_tr/2,1) ] ; 
	mat_tr = buf2mat(signal,l_tr,l_tr-recouv,fen);
else
	N_tranche = ceil(N/l_tr);
	nb_pad = 0;
	if rem(N,l_tr)
		nb_pad = l_tr-rem(N,l_tr);
	end
	signal = [ signal; zeros(nb_pad,1)];
   mat_tr = reshape(signal,l_tr,N_tranche);
   mat_tr = mat_tr.*fen(:,ones(1,N_tranche));
end

% Les diff'erentes tranches se trouvent maintenant en colonne 
[ l_tr, n_tr ] = size(mat_tr);


% Calcul de la DSP de la tranche (priodogramme)
% Du signal fenetr (par hanning)	
dsp_tr = 1/l_tr * (abs(fft(mat_tr))).^2;

% Normalisation  96 dB, elle correspond en fait 
%  une translation en dB (et non une homothtie).

% Passage en dcibel
dsp_db1 = 10 * log10( dsp_tr(1:l_tr/2,:) );
offset = 96 - max(dsp_db1);
dsp_db = dsp_db1 + offset(ones(1,l_tr/2),:);

% Conversion en bark
axef = (0:l_tr/2-1) * fe/l_tr; % Axe des frquences 
axeb = transpose(hz2bk(axef,1));	  % Axe des Barks
axebmat = axeb(:,ones(1,n_tr));

% --------------------------------------------------
% Recherche des composantes tonales et non tonales
% leurs indices sont stocks dans Nn et Nt
% --------------------------------------------------

% On spare les 3 cas possibles
% indices correspondant  4k et 8 kHz
ind4k = round(l_tr/fe*4000);
ind8k = round(l_tr/fe*8000);

% On garde de la reconnaissance des tonales du Mpeg
% avec une regle de 3, suivant Fe.
n1 = floor(2*fe/32000);
n2 = floor(3*fe/32000);
n3 = floor(6*fe/32000);

if n1 < 2
	n1 =2;
end
if n2 < 2
	n2 =2;
end
if n3 < 2
	n3 =2;
end

limite1 = [-n1:-2 2:n1]; l1 = length(limite1);
limite2 = [n2:-2 2:n2]; l2 = length(limite2);
limite3 = [-n3:-2 2:n3]; l3 = length(limite3);

% Initialisation de la matrice tonales (Mij=1) / non tonales (Mij=0)
Nton = zeros(l_tr/2,n_tr);

% F dans [0,4kHz]
for k = 2:ind4k-1 ;
   limite = limite1(find(limite1+k >= 1 & limite1+k <= l_tr/2));
   l1 = length(limite);
   % Premires conditions
   buf = dsp_db(k,:);
	test1 = ( buf(ones(1,2),:) >= dsp_db(k+[-1 1],:) );
	test2 = ( buf(ones(1,l1),:) - dsp_db(k + limite,:) >=7 );
		Nton(k,:) = floor(sum(test1)/2) & floor(sum(test2)/l1); % les tonales sont a un
end

if fe >=16000
   
   % F dans [4,8kHz]
   for k = ind4k : ind8k -1;
      limite = limite2(find(limite2+k>=1 & limite2+k <= l_tr/2));
      l2 = length(limite);
      % Premires conditions
      buf = dsp_db(k,:);
      	   test1 = ( buf(ones(1,2),:) >= dsp_db(k+[-1 1],:) );
	   test2 = ( buf(ones(1,l2),:) - dsp_db(k + limite,:) >=7 );
   
   	   Nton(k,:) = floor(sum(test1)/2) & floor(sum(test2)/l2); % les tonales sont a un
   end
   
   % F dans [8,Fe/2kHz]
   for k = ind8k : l_tr/2-1;
      limite = limite3(find(limite3+k <= l_tr/2));
      l3 = length(limite);
      buf = dsp_db(k,:);
   	   test1 = ( buf(ones(1,2),:) >= dsp_db(k+[-1 1],:) );
	   test2 = ( buf(ones(1,l3),:) - dsp_db(k + limite,:) >=7 );
   
  	   Nton(k,:) = floor(sum(test1)/2) & floor(sum(test2)/l3); % les tonales sont a un
   end
end

Nt = find(Nton); % donne les indices des tonales dans Nton
% Renforcement de la puissance des tonales
dsp_db(Nt) = 10 * log10( 10.^(dsp_db(Nt-1)/10) + 10.^(dsp_db(Nt)/10) + ...
		10.^(dsp_db(Nt+1)/10) );
dsp_db(Nt-1) = -100;
dsp_db(Nt+1) = -100;

% Regroupement des tonales 
% Distante de moins de 0.5 Bark
indcol = ceil(Nt/(l_tr/2));
indbark_ton = axebmat(Nt);

ecartbark = diff(indbark_ton,1);
ecartcol = diff(indcol,1);

ind = find((ecartbark<0.5 & ecartcol == 0));

% On elimine la moins puissante

Nton(Nt(ind)) = dsp_db(Nt(ind)) > dsp_db(Nt(ind+1));


% --------------------------------------------------------
% Donnes pour les courbes de masquage
% --------------------------------------------------------
% Attention, il faut maintenant travailler en Barks
% par contre, faut-il travailler en dB ???
	
% Indices de masquage  la frquence considre
%	a_t = -1.525 - 0.275*axeb(Nn) - 4.5;	% pour les tonales
%	a_n = -1.525 - 0.175*axeb(Nt) - 0.5;	% pour les non tonales
	
% fonction de masquage
% --------------------------------------------------------
Mask = zeros(l_tr/2,n_tr);

% On ajoute les indices de masquages
%Mask(Nt) = a_t;
%Mask(Nn) = a_n;

% On prend une valeur nulle pour Nt, au cas ou il n'y est pas de tonales
if isempty(Nton)
   Nton = 0;
end

for k = 1 : l_tr/2
   
   % On recherche l'talement : de -3  8 Barks
		f1 = axeb(k);	% Frequence ou l'on se situe en Bark
		P1 = dsp_db(k,:); % Dsp des tranches a la longueur consideree
	% 1. f entre -3 <= f < -1
   ton1 = find((axeb>=f1-3) & (axeb<f1-1));
   l1 = length(ton1);
	% 2. f entre -1 <= f < 0
   ton2 = find((axeb>=f1-1) & (axeb<f1));
   l2 = length(ton2);
   % 3. f entre 0 <= f < 1
   ton3 = find((axeb>=f1) & (axeb<f1+1));
   l3 = length(ton3);
	% 4. f entre 1 <= f < 8  >>>> on etend jusqu'a la fin de l'axe
   ton4 = find((axeb>=f1+1) ); 	%% <<<<< & (axeb<f1+8));
   l4 = length(ton4);
      
     	vectind = [ton1; ton2; ton3; ton4 ];
        letal = l1 + l2 + l3 + l4; 
   % Pour chaque tranche, l'etalement ne depend que des barks
   Etal = zeros(letal,n_tr);
   if ~isempty(ton1)
      Etal(ton1,:) =17 * (axebmat(ton1,:)-f1 +1) - (0.4* P1(ones(1,l1),:)+ 6);
   end
   if ~isempty(ton2)
      Etal(ton2,:) = (0.4* P1(ones(1,l2),:) + 6) .* ((axebmat(ton2,:)-f1));
   end
   if ~isempty(ton3)
	   Etal(ton3,:) = - 17 * ((axebmat(ton3,:) - f1));
	end
	if ~isempty(ton4)
   		Etal(ton4,:) = - ((axebmat(ton4,:) - f1) - 1 ).*(17 - 0.15*P1(ones(1,l4),:)) - 17;
	end
   
		a_t = -1.525 - 0.275*axeb(k) - 4.5;	% pour les tonales
      a_n = -1.525 - 0.175*axeb(k) - 0.5;	% pour les non tonales
      Tonal = Nton(k,:) * a_t + not(Nton(k,:)) * a_n;
      Etal(vectind,:) = Etal(vectind,:) + P1(ones(1,letal),:) + Tonal(ones(1,letal),:);
% -------------------------------------------------------------------------------
% Au lieu d'ajouter les contributions des courbes, on dcide de ne garder
% que celle qui est maximale de manire  avoir une courbe forward - adaptative
% -------------------------------------------------------------------------------
%	Mask(vectind) = 10*log10(10.^(Mask(vectind)/10) + 10.^(Etal(vectind)/10));
% devient (par rapport a "funcmasq.m"):
	Mask(vectind,:) = max(Mask(vectind,:),Etal(vectind,:));
end

% Prise en compte du seuil absolu d'audition

seuil_absolu = discretseuil(l_tr,fe);
seuil_absolu = seuil_absolu';
Mask = max(seuil_absolu(:,ones(1,n_tr)),Mask);

% On dnormalise le spectre
Mask = Mask - offset(ones(1,l_tr/2),:);

% Calcul du Rapport signal a masque
SMR = dsp_db1 - Mask;