function noy_MLT = noyMLT(M);

% function noy_MLT = noyMLT(M);
% Matrice Mx2M contenant les noyaux de la MLT

% On fait une matrice M x 2M.
% n de 0  2M-1
n = (0:2*M-1);

% k de 0  M-1
k = (0:M-1);

% Fentre de la MLT (demi periode de sinus sur une longueur 2M)
factsin = pi/(2*M);
factext = sqrt(2/M);
fenetre = factext * sin( (n+0.5) * factsin);
fenetre = fenetre(ones(1,M),:);

% Arguments du cosinus relatifs  n et k

phi_k = transpose(2*k + 1);
fact = pi/(4*M);
phi_n =  (2*n+1+M)*fact;

arg_cos = phi_k * phi_n ;

noy_MLT = cos(arg_cos);

noy_MLT = fenetre .* noy_MLT;
