function y = nrj(x,dim)

% NRJ Energy of elements
%    For vectors, NRJ(x) is the energy of the elements of x.
%
%    NRJ(x,dim) computes the energy along dimension dim
%
%    Example: If X = [0 1 2
%                     3 4 5]
%    then nrj(X,1) is [4.5 8.5 14.5] and nrj(X,2) is [ 1.66
%                                                     16.66];
 
if nargin < 2
    dim = 1;
end

L = size(x,dim);

carre= x.*x;
s=sum(carre,dim);
y = s/L;
