function hist = repart_nrj(signal,lfen,visu)

% function hist = repart_nrj(signal,lfen, ] visu)
% donne l'nergie de chaque tranche de longueur lfen du signal
% en vue de la recherche de contexte adapt
% ou de l'allocation de bits
% Entres : signal : matrice de vecteurs lignes contenant les coef de signal
%			(ex: matrice donne par MLT_analysis)
%	    lfen : longueur des sous bandes dont on calcule l'energie	
%    	    visu : variable optionnelle pour voir les pourcentages 
%	       relatifs  chaque tranche

if nargin < 3
	visu = 0;
end

[nlig,lsig] = size(signal);
n_tr = ceil(lsig/lfen);
hist = zeros(nlig,n_tr);

for k = 1:n_tr-1
	hist(:,k) = nrj(signal(:,(k-1)*lfen+1:k*lfen),2);
end

hist(:,end) = nrj(signal(:,(n_tr-1)*lfen+1:end),2);

if visu==1
	for k = 1:nlig
		bar((1:lfen:lsig)+lfen/2,(100 * hist(k,:)/(n_tr*nrj(signal(k,:),2))))
		title([ num2str(k) 'me tranche' ])
		pause(1)
	end
end