function [mat,nzeros] = splitvec(buf,np,shift,w)

% SPLITVEC - convert vector to matrix with overlap between frames
%[MAT,NZEROS] = splitvec(X,M,SHIFT);
%       Split Vector X to a matrix where each column
%       is made a M long frame of X, overlapping
%	of a factor M - SHIFT with the previous column
%
%MAT = splitvec(BUF,M,SHIFT,W)
% 	windows each column by a specified window vector (of length M).
%
% SEE ALSO - RESHAPE, VEC2MAT

% Gilles Gonon
% 09-11-2000 (french date)

buf = buf(:)';
lenb = length(buf);

n_tr = floor((lenb - np)/shift) + 1;

ind = (1:np)';
ind = ind(:,ones(1,n_tr+1));
indplus = (0:shift:n_tr*shift);
indplus = indplus(ones(np,1),:);

indmat = indplus + ind;
% On supprime les colones en trop
[i1,j1] = ind2sub(size(indmat),find(indmat==lenb));
if length(j1)>1
 indmat(:,j1(2:end)) = [];
end
indzeros = find(indmat>lenb);
indmat(indzeros) = 1;

nzeros = length(indzeros);

mat = buf(indmat);
mat(indzeros) = 0;

if nargin==4,
   [ nl,nc ] = size(mat);
   w = w(:);
   w = w(:,ones(1,nc));
   w(1:floor(nl/2),1) = 1;
   w(floor(nl/2)+1:nl,nc) = 1;
   mat = w.*mat;
end