function s_sur_ech =  sur_ech(s,fact,dim)
% Appel :  s_sur_ech =  sur_ech(s,fact,]dim)
% Surchantillonne le signal s d'un facteur fact
% Si s est une matrice, on sur-echantillonne suivant dim :
% 	dim = 1 (defaut) suivant les colonnes (ajout de colonnes)
% 	dim = 2 suivant les lignes (ajout de lignes)
% fact doit etre entier
%  Renvoie s_ss_ech

[lig,col] = size(s);

if nargin < 3
	dim =1;
end

% On test si s est une matrice
% pour ne sous echantillonner que la dimension la plus longue

if dim == 1 	% Vecteur ligne (plus de colonnes)
	 	% longueur du signal surchantillonn
	N_surech = col*fact;
	  	% on cree un vecteur de longueur finale remplit de zeros
	  	% c'est pour que ca aillle plus vite qu'avec la boucle
	s_sur_ech = zeros(lig,N_surech);
	  	%on le remplit alors avec les echantillons de s
	s_sur_ech(:,1:fact:N_surech) = s;
	
else 		% Vecteur colonne
	N_surech = lig*fact;
	s_sur_ech = zeros(N_surech,col);
	s_sur_ech(1:fact:N_surech,:) = s;
end
	