function vect_node = tree2node(tree)

% Fonction donnant les noeuds terminaux
% dans une arbre issu de recherche de meilleure base

% On recherche les 0 dans BestTree qui correspondent
% au noeud ventuellement terminaux

[ d,b ] = invnode(find(tree==0));
l = length(d);


noeud = d' + i* b';

vect_node = [];
% recherche alors les noeuds qui sont terminaux

for k = l:-1:1 	% on parcours n et d de la profondeur max -> min
	
	noeud_inf = d(k)-1 + i*(floor(b(k)/2));

 	if find(noeud_inf==noeud)		% noeud non terminal
 	else 
 		vect_node = [ d(k) b(k) ; vect_node ];	% noeud terminal
 	end 	
end;

% il reste  enlever les noeuds non cohrents ( si des 1 n'ont
% pas t enlevs dans bestree, ce qui arrive souvent)

node_complx = vect_node(:,1) + i* vect_node(:,2);

D = nextpow2(length(tree))-1;	% profondeur de la dcomposition

k = 1;
while k < length(vect_node(:,1))

	% on gnre tous les fils d'un noeud jusqu'a la profondeur finale
	fils = zeros(1,2^(D-vect_node(k,1)+1)-2);
	
	% L'indexation des fils est un peu complique 
	% (il doit y avoir plus simple)
	for prof = vect_node(k,1) : D-1
		d_relatif = prof-vect_node(k,1)+1;

		fils( 2^d_relatif -1 : 2^(d_relatif+1)-2 ) = ...
prof+1 + i*(2^d_relatif*vect_node(k,2) :  2^(d_relatif)*(vect_node(k,2)+1)-1 );
	end
	
	% On teste si les fils sont dans vect_node
	for ptr = 1:length(fils)
		ind = find(node_complx == fils(ptr));
		vect_node(ind,:) = [];
		node_complx(ind) = [];
	end
	
	k = k+1;
end


