function mat_mlt = unallocMLT(ss_band,coef,lMLT)

% function mat_mlt = unallocMLT(ss_band,coef,lMLT)
% Reconstruit la matrice des coefs de MLT `a partir des valeurs
% donn'ees par allocMLT.
% Entr'ees : ss_band. No des sous bandes conserv'ees taille (n_tr,nb_ssband)
%				coef. Valeurs des coef gard'es. taille (nb_ssband*lfen,n_tr)
% lMLT est la longueur des MLT
% Sorties : mat_mlt matrice des coef de MLT taille (n_tr,lMLT)

[ n_tr, nb_kept ] = size(ss_band);
[ nb_coef, n_tr ] = size(coef);
lfen = nb_coef / nb_kept;

% Initialisation de la matrice des coefs de MLT
mat_mlt = zeros(1,n_tr*lMLT);

% Deroulement des coef

coef = reshape(coef,1,nb_coef*n_tr);

% Reconstruction des pointeurs dans mat_mlt a partir
% de ss_band

ss_band_se = sur_ech((ss_band-1)*lfen+1,lfen);
for k = 2:lfen
   ss_band_se(:,k:lfen:end) = (ss_band-1)*lfen+k;
end

% on deroule maitenant les pointeurs sur sous bandes
cte1 = nb_kept*lfen;
ind_coef = transpose( (0:n_tr-1) * lMLT );
ind_coef = reshape( (ss_band_se + ind_coef(:,ones(1,cte1)))',1,n_tr*cte1);

mat_mlt(ind_coef) = coef;

% On reforme la matrice
mat_mlt = reshape(mat_mlt,lMLT,n_tr);

mat_mlt = transpose(mat_mlt);